#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)30   1.79   src/csm/core/pm/ArchiveUtils.pm.perl, setup, csm_rameh, rameh0431a 7/26/04 22:20:58

#####################################################################

package ArchiveUtils;

use strict;

#            locale tells perl to honor locale for sorting, dates, etc.
#            More info about locale.pm and perl handling of locales can be found in
#            /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.
use locale;
use Socket;
use File::Glob ':glob';
use File::Basename;

my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;
my $NODEGROUPEXPMEM_WARNING = 1;

# $NodeUtils::NO_MESSAGES;    # Set this to 1 if you do not want NodeUtils to
# print any error msgs

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
# this out before calling a NodeUtils function,
# if you want to check it afterwards.

BEGIN
{

    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

    $MSGCAT = 'nodecmds.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'NodeUtils';
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use ArchiveUtils;" line

#--------------------------------------------------------------------------------

=head1    ArchiveUtils

=head2    Package Description

This program module file, supports the CSM/install archiving and open source
dependencies.  

If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use of
         your contrib.

    2. Your contrib is under the correct heading and is in alphabetical order
    under that heading.

    3. You test your contribution by running from the command line:  

       pod2html  --verbose --title=ArchiveUtils ArchiveUtils.pm.perl --outfile=ArchiveUtils.html
       
       and examining the ./ArchiveUtils.html file in a browser.


=cut

#--------------------------------------------------------------------------------

=head2    Package Dependancies

    use strict;
    use Fcntl qw(:flock);
    use File::Basename;
    use File::Find;
    use File::Path;    # Provides mkpath()

=cut

#--------------------------------------------------------------------------------

=head1    Subroutines by Functional Group

=head2    Licence Support

=cut

#--------------------------------------------------------------------------------

=head3 display_opensrcLicence

        Display the open source product licence

        Arguments:
                rpm name
        Returns:
                none
        Globals:
                @::GPL_PACKAGES)
                $::DISPLAYED_GPL_LICENSE
                $::PREREQS_ATTR{
        Error:
                none
        Example:
                ArchiveUtils->display_opensrcLicence( $rpmName );
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub display_opensrcLicence
{
    my ($class, $rpm) = @_;

    # If this is one of the GPL open source packages, display a license
    # agreement.  Don't display the license again if it has already been
    # displayed.
    if (grep(/^$rpm$/, @::GPL_PACKAGES) and !$::DISPLAYED_GPL_LICENSE)
    {
        if ($::PREREQS_ATTR{'PkgArchitecture'} =~ /ppc64/)
        {

            # NodeUtils->message('I', 'IMsgGPL_LICENSE_PPC64');
            # NodeUtils->message('P', 'IMsgPRESS_ENTER_TO_INSTALL_PPC64');
        }
        else
        {
            NodeUtils->message('I', 'IMsgGPL_LICENSE');
            NodeUtils->message('P', 'IMsgPRESS_ENTER_TO_INSTALL');
            my $t = <STDIN>;
            chop($t);
            if (length($t) > 0)
            {
                NodeUtils->message('I', 'IMsgCSM_NOT_INSTALLING');
                exit 1;
            }
        }

        # Set to 1 so the license is not displayed again.
        $::DISPLAYED_GPL_LICENSE = 1;
    }
}

#--------------------------------------------------------------------------------

=head3    invokeLAP

        Invoke the LAP tool and display the CSM license agreements.
        The LAP tool will be invoked and copy the LA and LI files to

            /var/opt/csm/<VRnumber>/<type>/license/<lang>.txt
        Where:
                <VRnumber> = CSM Version (1.3, etc)
                <type>     = tryandbuy or full, depending upon the license.
                <lang>     = one of the 17 supported LAP languages.

        Arguments:
                A string - either: "tab" or "full"

        Returns: one of [ 3 | 9 | 127 ]
                If everything ran successful, then LAP will return 9,
        otherwise, if the user returns 3, the license was not
        accepted.  If something went wrong with the LAP tool,
        then an error of 127 will be returned.
        Error:
                127

        Example: Doesn't appear to be used in csm/install

        Comments: none

=cut

#--------------------------------------------------------------------------------

sub invokeLAP
{
    my ($class, $licType) = @_;
    my ($csmVersion, $laDir, $strCmd, $rc);
    my $laptool = "/opt/csm/install/lapapp.jar";

    # make sure that $licType is either tab or full
    if ($licType eq "tab")
    {
        $licType = "tryandbuy";
    }
    elsif ($licType ne "full")
    {

        #print "don't know..\n";
        return 127;
    }

    # get the CSM version:
    $csmVersion = InstallUtils->get_CSMVersion("csm.server");
    $csmVersion = sprintf "%.1f", $csmVersion;                  # e.g. "1.3"

    # check that the LA and LI files are in place:
    if (NodeUtils->isLinux())
    {
        $laDir = "/opt/csm/install/$csmVersion/Linux/license/$licType";
    }
    else                                                        # AIX
    {
        $laDir = "/opt/csm/install/$csmVersion/AIX/license/$licType";
    }

    unless (-f "$laDir/LA_en")
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',     $::MSGMAPPATH,
                                  'csminstall',         'E127',
                                  'EMsgCANT_READ_FILE', "$laDir/LA_en"
                                  );
    }

    # check that the LAP tool is in place:
    unless (-f "$laptool")
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E127', 'EMsgCANT_READ_FILE', $laptool);
    }

    # Everything should be in place now, so let's call LAP and  construct the command:

    if (NodeUtils->isLinux())
    {
      #try to find java
      my $found_java=0;
      my ($java, $rt, $i18n);
      my @output = NodeUtils->runcmd("$::LS -1d /opt/IBMJava\*");
      while(($found_java!=1) && (@output)){
	my $dir = shift @output;
	$dir =~ s/^\s*//;    # Remove any leading whitespace
	$dir =~ s/\s*$//;    # Remove any trailing whitespace
	my $tmp_java = "$dir/jre/bin/java";
	my $tmp_rt = "$dir/jre/lib/rt.jar";
	my $tmp_i18n = "$dir/jre/lib/i18n.jar";
	if(-e "$tmp_java")
	  {
	    $found_java=1;
	    $java = $tmp_java;
	    $rt = $tmp_rt;
	    $i18n = $tmp_i18n;
	  }
      }
      if($found_java){
	$strCmd = "$java -cp /opt/csm/install/lapapp.jar:${rt}:${i18n}:";
      }
      else{ #try the old way
        # check that Java is installed... and use the right one.
        if (-d "/opt/IBMJava2-141")
        {
            $strCmd = "/opt/IBMJava2-141/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/opt/IBMJava2-141/jre/lib/rt.jar:";
            $strCmd .= "/opt/IBMJava2-141/jre/lib/i18n.jar:";
        }
        elsif (-d "/opt/IBMJava2-131")
        {
            $strCmd = "/opt/IBMJava2-131/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/opt/IBMJava2-131/jre/lib/rt.jar:";
            $strCmd .= "/opt/IBMJava2-131/jre/lib/i18n.jar:";
        }
        elsif (-d "/opt/IBMJava2-13")
        {
            $strCmd = "/opt/IBMJava2-13/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/opt/IBMJava2-13/jre/lib/rt.jar:";
            $strCmd .= "/opt/IBMJava2-13/jre/lib/i18n.jar:";
        }
        elsif (-d "/opt/IBMJava2-ppc-141")
        {
            $strCmd = "/opt/IBMJava2-ppc-141/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/opt/IBMJava2-ppc-141/jre/lib/rt.jar:";
            $strCmd .= "/opt/IBMJava2-ppc-141/jre/lib/i18n.jar:";
        }
        elsif (-d "/opt/IBMJava2-ppc-131")
        {
            $strCmd = "/opt/IBMJava2-ppc-131/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/opt/IBMJava2-ppc-131/jre/lib/rt.jar:";
            $strCmd .= "/opt/IBMJava2-ppc-131/jre/lib/i18n.jar:";
        }
        elsif (-d "/usr/lib/IBMJava2-1.3.1")
        {
            $strCmd = "/usr/lib/IBMJava2-1.3.1/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/usr/lib/IBMJava2-1.3.1/jre/lib/rt.jar:";
            $strCmd .= "/usr/lib/IBMJava2-1.3.1/jre/lib/i18n.jar:";
        }
        else    # java isn't installed maybe
        {
            my $string = "IBMJava2-13[1]";
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',     $::MSGMAPPATH,
                                      'csminstall',         'E127',
                                      'EMsgMissingPackage', $string
                                      );
        }
      }
    }
    else
    {           # AIX
      #try to find java
      my $found_java=0;
      my ($java, $rt, $i18n);
      my @output = NodeUtils->runcmd("$::LS -1d /usr/java\*");
      while(($found_java!=1) && (@output)){
	my $dir = shift @output;
	$dir =~ s/^\s*//;    # Remove any leading whitespace
	$dir =~ s/\s*$//;    # Remove any trailing whitespace
	my $tmp_java = "$dir/jre/bin/java";
	my $tmp_rt = "$dir/jre/lib/rt.jar";
	my $tmp_i18n = "$dir/jre/lib/i18n.jar";
	if(-e "$tmp_java")
	  {
	    $found_java=1;
	    $java = $tmp_java;
	    $rt = $tmp_rt;
	    $i18n = $tmp_i18n;
	  }
      }
      if($found_java){
	$strCmd = "$java -cp /opt/csm/install/lapapp.jar:${rt}:${i18n}:";
      }
      else{
	if (-d "/usr/java141")
        {
            $strCmd = "/usr/java141/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/usr/java141/jre/lib/rt.jar:";
            $strCmd .= "/usr/java141/jre/lib/i18n.jar:";
        }
        else
        {
            $strCmd = "/usr/java131/jre/bin/java -cp ";
            $strCmd .= "/opt/csm/install/lapapp.jar:";
            $strCmd .= "/usr/java131/jre/lib/rt.jar:";
            $strCmd .= "/usr/java131/jre/lib/i18n.jar:";
        }
      }
    }

    # this part of the command is common in both AIX and Linux:
    $strCmd .= " com.ibm.lex.lapapp.LAP ";
    $strCmd .= "-l $laDir ";
    $strCmd .= "-s /var/opt/csm/$csmVersion/$licType ";
    $strCmd .= "-text_only";
    $rc = system("$strCmd");
    $rc = $rc >> 8;

    # kill processes if they exist:
    if (NodeUtils->isLinux)
    {
        foreach (`ps -efl --columns 300 | grep lapapp | awk '{print \$4}'`)
        {
            chomp $_;
            `kill -9 $_ 2>/dev/null`;
        }
    }

    return $rc;
}

#--------------------------------------------------------------------------------

=head2    RPM Support

=cut

#--------------------------------------------------------------------------------

=head3    checkDistroCopied

        Determine if there are more than 100 files in /csminstall/RPMS
    directory

        Arguments:
                $rpmDirectory

        Returns:
                1 - more than 100 files in /csminstall/RPMS
                0 - eveything okay
        Globals:
                none
        Error:
                1
        Example:
                never used
        Comments:
                never used???

=cut

#--------------------------------------------------------------------------------

sub checkDistroCopied
{
    my ($class, $rpmdir) = @_;

    if (!-e "$rpmdir")
    {
        return 0;
    }
    my @output = `$::LS -l $rpmdir/ | /usr/bin/wc -l`;
    chomp @output;
    my $lines = $output[0];
    $lines =~ s/\s+//;
    if ($lines > 100)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

#--------------------------------------------------------------------------------

=head3    checkForRpmTool

        Exits E2 if the rpm tool is not installed on the local host.

=cut

#--------------------------------------------------------------------------------

sub checkForRpmTool
{
    my $ret_code;

    $ret_code = NodeUtils->get_CSMVersion("rpm");
    if (length($ret_code) == 0)
    {
        NodeUtils->message('E2', 'EMsgNO_RPM');
    }
}

#--------------------------------------------------------------------------------

=head3    checkRPMInstall

        Checks if a given rpm is installed. The full pathname of the
        rpm must be given.


        Arguments:
                $rpmName


        Returns:
                0 - not installed
                1 - installed

        Globals:
                $::PLTFRM
                $::rpmShortnames
                $::rpmBasenames
        Error:
                0

        Example:
                 my $installed =
                        ArchiveUtils->checkRPMInstall($rpmFileName);

        Comments:
                checkRPMInstall must be called before this function is used.

=cut

#--------------------------------------------------------------------------------

sub checkRPMInstall
{
    my ($class, $filename) = @_;    #rpm name
    my $file;
    if ($::PLTFRM eq "AIX")
    {
        my @output =
          `$::RPMCMD -q --qf %{NAME}-%{VERSION}-%{RELEASE} -p $filename`;
        chomp @output;
        $file = $output[0];
    }
    else
    {
        my @path = split '/', $filename;
        $file = pop @path;
    }

    #determine if the given rpm is installed on the system
    #we need to check to see if this rpm is already installed
    my ($shortname, $basename, $p);
    my @parts = split /-/, $file;
    $shortname = shift @parts;
  SNAME: while ($p = shift @parts)
    {
        if ($p !~ m/^\d/)
        {    #if it doesn't start with a digit
            $shortname .= "-$p";
        }
        else
        {
            unshift @parts, $p;
            last SNAME;
        }
    }
    $basename = $shortname;
    $shortname .= "-" . $parts[0] . "-" . (split /\./, $parts[1])[0];
    if (!exists $::rpmShortnames{$shortname})
    {

        #so check the basename
        if (!exists $::rpmBasenames{$basename})
        {

            #no version of this rpm is installed
            #push @rpms, $wholename;
            return 0;
        }
        else
        {
        	# If the required os package is installed,  CSM need not install them 
        	# This is because the cooperation between different  the Service Level 
        	foreach my $rpm (@::linux_os_prereqs) {
        		if ($rpm =~ /^(.*)\*$/) {
        			$rpm=$1;
        		}
        		my $rpmname = substr ($shortname,0,length $rpm);
        		if ($rpmname eq $rpm) {

        			NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                              'V', 'IMsgRPM_ALREADY_INSTALLED', $file);
                            return 1;        		
        		}
        	}
        	# a different version of this rpm is installed
                #test to see if this rpm  is installed
                # Check if the RPM is already installed at the correct version
            my $cmd = "$::RPMCMD -U --test $filename";
            NodeUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
                                      'NodeUtils', 'V', 'IMsgCMD', $cmd);
            my @cmdout = `LANG=C $cmd 2>&1`;
            my $rc     = $? >> 8;
            my $cmdout = join('', @cmdout);    # Put output into a single string
            if ($cmdout !~ /package .* is already installed/)
            {

                #not installed
                return 0;
            }
        }
    }
    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                              'V', 'IMsgRPM_ALREADY_INSTALLED', $file);
    return 1;                                  #it is installed
}

#--------------------------------------------------------------------------------

=head3    check_valid_install_distros

        Check whether current node's InstallDistributionName and
        InstallDistributionVersion is valid for full installation

        Arguments:
                $installMethod
                $distribution
        Returns:
                -1 - not valid
                0  - valid

        Globals:
                none
        Error:
                returns -1

        Example:
                 my $installed =
                    ArchiveUtils->check_valid_install_distros( $installMethod,
                                                               $distribution );
        Comments:
                 none

=cut

#--------------------------------------------------------------------------------

sub check_valid_install_distros
{
    my ($class, $installmethod, $distro) = @_;

    my @VALID_AUTOYAST_DISTROS = ('SuSE8.1', 'SLES8.1', 'SLES9');

    if (!grep(/^$distro$/, @VALID_AUTOYAST_DISTROS))
    {
        return -1;
    }
    return 0;
}

#--------------------------------------------------------------------------------

=head3	getServiceLevel

        Notes: This routine just a temperary solution for RedHatEL-AS3

=cut

#--------------------------------------------------------------------------------
sub getServiceLevel
{
    my $readme = "/csminstall/Linux/$::DISTRO_NAME/$::DISTRO_VERSION/$::ARCH/README";
    my $sp=undef;

    if(-l "$readme")
    {
	my $target = readlink "$readme";
	if($target =~ /RedHatEL\-AS3\-ppc64/){
	    $sp = "QU1";
	}elsif($target =~ /RedHatEL\-AS3\-QU2/){
	    $sp = "QU2";
	}
    }

    return $sp;
}

#
# Compatible for original routine
#
sub copyDistroCD
{
   my ($class, $distro_top, $distro_name, $distro_version) = @_;
   my $orig_dir;
   
   if (( $::PLTFRM eq "AIX")
        && !(($::ATTRS{'InstallDistributionName'} =~ /SuSE/) || 
		($::ATTRS{'InstallDistributionName'} =~ /SLES/)))
   {
         #change to the destination dir. if on AIX copying RedHat CDs
         use Cwd;
         $orig_dir = getcwd();
         chdir($distro_top);
   }

   ArchiveUtils->copyDistroPkgs($::ARCH,$distro_top,$distro_name,$distro_version,undef);
   ArchiveUtils->setupBootOrder($::ARCH,$distro_top,$distro_name,$distro_version,undef);
   
   if (($::PLTFRM eq "AIX")
        && !(($::ATTRS{'InstallDistributionName'} =~ /SuSE/) || 
		($::ATTRS{'InstallDistributionName'} =~ /SLES/)))
   {
       chdir($orig_dir);
   }
}


sub copyDistroPKGPATH
{
   my ($class, $distro_top, $distro_name, $distro_version) = @_;
   my $orig_dir;
   
   if (( $::PLTFRM eq "AIX")
        && !(($::ATTRS{'InstallDistributionName'} =~ /SuSE/) || 
		($::ATTRS{'InstallDistributionName'} =~ /SLES/)))
   {
         #change to the destination dir. if on AIX copying RedHat CDs
         use Cwd;
         $orig_dir = getcwd();
         chdir($distro_top);
   }

   ArchiveUtils->copyDistroPkgs($::ARCH,$distro_top,$distro_name,$distro_version,undef);
   ArchiveUtils->setupBootOrder($::ARCH,$distro_top,$distro_name,$distro_version,undef);
   
   if (($::PLTFRM eq "AIX")
        && !(($::ATTRS{'InstallDistributionName'} =~ /SuSE/) || 
		($::ATTRS{'InstallDistributionName'} =~ /SLES/)))
   {
       chdir($orig_dir);
   }
}


sub foundPkgPath
{
    my ($class,$suffix)=@_;
    my @files=();
    
    use DirHandle;
    
    $suffix=lc($suffix);
    my $err_dir;
    
    foreach my $dir(@::PKGPATH)
    {
        if(! -d $dir)
            {
            $err_dir .= "\'$dir\' ";
            next;
        }
	
	    push @files,$dir;
	
    	my $d=new DirHandle "$dir";
    	if(defined $d)
	{
    		while (defined($_ = $d->read))
    		{
    			next if($_ eq "." || $_ eq "..");
     			next if($_ !~/$suffix$/);
    			my $tmp_filenam="$dir"."/"."$_";
    			next if(! -f $tmp_filenam);
    			push @files,$tmp_filenam;
    		}
	}
    	undef $d;
    }
    if ($err_dir) {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,'csminstall', 'I', 'IMsgDIRECTORY_NOT_FOUND', $err_dir);
    }

     return @files;
}

sub probeImages
{
    my ($class,$r_pkgpath,$r_disks)=@_;
    my @pkgpath = @$r_pkgpath;
    my @disks   = @$r_disks;
    my $images  = { };
    my ($mntpoint,$ismounted);

    foreach my $diskref(@disks)
    {
    	my $diskname = $diskref->{name};
	my $disknum =  $diskref->{num};
    	
	foreach my $path(@pkgpath)
	{
		$ismounted = 0;
		
		if(-f $path && $path =~ /iso$/ )
		{
			# AIX does not support iso image
			next if ($::PLTFRM eq "AIX");
			
			$mntpoint = ArchiveUtils->mount_iso_image($path);
			if($mntpoint)
			{
				$ismounted = 1;
				#$path = $mntpoint;
			}else{
				NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'I', 'IMsgCANT_MOUNT', $path);
				next;
			}
		}elsif( -d $path){
			$mntpoint = $path;
		}

		# valid the disk
		my $progref = $diskref->{diskid_searchprog};
		my $progarg = $diskref->{diskid_searchargs};
		if( &$progref($mntpoint,$progarg) )
		{
			# yes , this is the required disk, save it
			$images->{$diskname}->{$disknum} = $path;
		}

		if($ismounted)
		{
			ArchiveUtils->unmount_iso_image($mntpoint);
			$ismounted = 0;
		}
	}
    }

    return $images;
}

sub is_req_disks_copied{
	my ($class,$distro_top,$ref_disks)=@_;
	my @disks = @$ref_disks;
	foreach my $diskref(@disks)
	{
                next if(defined($diskref->{not_for_full_install}) &&
                        $diskref->{not_for_full_install} eq 'TRUE');

		if(defined $diskref->{diskid_target})
		{
			my $target = $diskref->{diskid_target};
			if($target ne ""){
				if(!-e "$distro_top/$target"){return 0;}
			}
		}
	}

	return 1;
}

#--------------------------------------------------------------------------------

=head3   mkLinks 

        Arguments:
		$destdir
		$strFiles
        Returns:
		none
        Globals:
                none
        Error:
		none
        Example:
		none
        Comments:
              mkLinks is used to make links in for a boudle of files  a dest dir 
              if the link/file already exists, it will be removed. 

=cut

#--------------------------------------------------------------------------------

sub mkLinks{
    my ($class, $destdir, $strFiles)=@_;
    chdir $destdir; 
    my @filelist = bsd_glob($strFiles);
    my ($filename,$file);
    foreach $file(@filelist) {
            $filename = basename $file;
            # overwrite for a link file, but ignore for a normal file. 
            # The reason is because it is not very good to overwrite the RPMs copied by installms
            # need add a special parameter to control it?
            if (-l $filename)		
            {
                    unlink $filename;
            }
            symlink $file,$filename;
    }
}
#-------------------------------------------------------------------------------

=head3   remove_all_links

         Arguments:
         $basedir
         Returns:
           none
         Globals:
            none
         Error:
            none
	     Example:
		    none
       	 Comments:
		    none

=cut

#-------------------------------------------------------------------------------
sub remove_all_links{
    my ($class,$basedir)=@_;
	
    my $d=new DirHandle "$basedir";
    if(defined $d)
    {
    	while (defined($_ = $d->read))
    	{
    		next if($_ eq "." || $_ eq "..");
    		my $tmp_filenam="$basedir"."/"."$_";
    		if(-l "$tmp_filenam")
		{
    			unlink($tmp_filenam);
		}
   	}
    }
    undef $d;
}

sub setupBootOrder
{
    my ($class,$arch,$distro_top, $distro_name,$distro_version,$sp) = @_;
    my ($cmd,$output);
    my (@origdirs,@spdirs);
    my ($first_origdir,$first_spdir);
    
    if($arch =~ /i.86/) { $arch = "i386"; }
       
    my @orig_disks=@{$::pkgdefs{'distro_disks'}};
    
    # Make sure the original disks were copied
    if($distro_name =~ /SLES/ 
	&& !ArchiveUtils->is_req_disks_copied($distro_top,\@orig_disks))
    {
     	NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                  'csminstall', 'E1', 'EMsgDisksMissing');
    }
    
    foreach my $diskref(@orig_disks){
    	if(!grep(/$diskref->{diskid_target}/,@origdirs)){
		push(@origdirs,$diskref->{diskid_target});
	}
    }
    $first_origdir = $orig_disks[0]->{diskid_target};
    
    
    if($sp){
    	if(defined $::pkgdefs{'sp_disks'}{$sp})
	{
		 my @sp_disks=@{$::pkgdefs{'sp_disks'}{$sp}};
		 foreach my $diskref(@sp_disks){
			if(!grep(/$diskref->{diskid_target}/,@spdirs)){
				push(@spdirs,$diskref->{diskid_target});
			}
		 }
		 
		 $first_spdir = $sp_disks[0]->{diskid_target};
		 
		 if(!ArchiveUtils->is_req_disks_copied($distro_top,\@sp_disks)){
     			NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                	  	 'csminstall', 'E1', 'EMsgDisksMissing');
		 }
		 
	}else{
		NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
			'csminstall', 'E1', 'EMsgBadServiceLevel',$sp);
	}
	
    }

    
    if (($distro_name =~ /SuSE/) || ($distro_name =~ /SLES/)) {
    	
	my $realRPMS = "$distro_top/$distro_name/RPMS";
	        
	if ((($distro_name =~ /SLES/) && ($distro_version eq 8.1)) || (($distro_name =~ /SLES/) && ($distro_version eq 9))) {
	   my $directory_name;
	   my $disk_name;
	   # Use different directory name for SLES8.1 and SLES9
	   if ($distro_version eq 8.1) {
		$directory_name = "sles8";
		$disk_name = "ul";
	   } else {
		$directory_name = "sles9";
		$disk_name = "core9";
	   }
	   foreach my $subpath(@origdirs){
			ArchiveUtils->mkLinks($realRPMS, "../../$subpath/*/*/*.rpm");
	   }

	   if ($sp) {
		 foreach my $subpath(@spdirs){
			ArchiveUtils->mkLinks($realRPMS, "../../$subpath/*/*/*.rpm");
		 }
	   }
	   
	   $cmd = "$::COPY -a $distro_top/$first_origdir/yast $distro_top/$first_origdir/boot $distro_top/$first_origdir/content $distro_top/$first_origdir/media.1 $distro_top";
	   NodeUtils->runcmd($cmd,-1);
	   
	   if($arch =~ /ppc64/){
		   
		$cmd = "$::MKDIR $distro_top/yast";
		NodeUtils->runcmd($cmd, -1);
		
		if($sp){
			$cmd =
			"$::COPY -a $distro_top/$first_spdir/media.1 $distro_top/$first_spdir/driverupdate $distro_top/$first_spdir/boot $distro_top";
			NodeUtils->runcmd($cmd, -1);	
			$cmd=
			"$::MKDIR -p $distro_top/updates/kernel ; $::COPY $distro_top/$first_spdir/suse/ppc/kernel-ppc64*.ppc.rpm $distro_top/updates/kernel";
                     NodeUtils->runcmd($cmd, -1);		
		}
		
	   }else{
	   	$cmd = "$::MKDIR -p $distro_top/yast/$directory_name/suse/setup/descr";
	   	NodeUtils->runcmd($cmd,-1);
	   
           	$cmd = "$::COPY -a $distro_top/$first_origdir/suse/setup/descr $distro_top/yast/$directory_name/suse/setup";
	   	NodeUtils->runcmd($cmd, -1);
	   
	   	$cmd = "$::COPY -a $distro_top/$first_origdir/content $distro_top/$first_origdir/media.1 $distro_top/yast/$directory_name";
	   	NodeUtils->runcmd($cmd,-1);

                if($sp){
                     $cmd = "$::COPY -a $distro_top/$first_spdir/linux $distro_top/$first_spdir/driverupdate $distro_top";
                     NodeUtils->runcmd($cmd,-1);
		     
                     $cmd = "$::COPY -a $distro_top/$first_spdir/boot/loader/linux $distro_top/boot/loader/";
                     NodeUtils->runcmd($cmd,-1);
		     
                     $cmd = "$::COPY -a $distro_top/$first_spdir/boot/loader/initrd $distro_top/boot/loader/";
                     NodeUtils->runcmd($cmd,-1);
                }	
	  }
	   
	  my $order = "$distro_top/yast/order";
	  my $instorder = "$distro_top/yast/instorder";

	  if($arch =~ /ppc64/){
	  	if (open(FILE, ">$instorder"))
		{
		  	print FILE "$first_origdir\t$first_origdir\n";
			if($sp)
			{
				print FILE "$first_spdir\t$first_spdir\n";
			}
			# for SLES9, add path for the CORE CDs
			if ($distro_version eq 9) {
                                my $sec_origdir=$orig_disks[1]->{diskid_target};
                                print FILE "$sec_origdir\t$sec_origdir\n";
                        }

			close(FILE);
		}
	  }
	  
	  if ( open(FILE, ">$order")) {
	      if($arch =~ /ppc64/){
		      if ($sp)
		      {
			      print FILE "$first_spdir\t$first_spdir\n";
		      }
		      print FILE "$first_origdir\t$first_origdir\n";
		      # For SLES9, Add path for CORE CDs
                      if ($distro_version eq 9) {
                              my $sec_origdir=$orig_disks[1]->{diskid_target};
                              print FILE "$sec_origdir\t$sec_origdir\n";
                      }
	      }else{
		      if ($sp=~ /SP3/) {
			      print FILE "/$first_spdir\t/$first_spdir\n";
		      }
		      my $sec_origdir=$orig_disks[1]->{diskid_target};
		      print FILE "/yast/$directory_name\t/$first_origdir\n";
		      print FILE "/yast/$disk_name\t/$sec_origdir\n";
	      }
	      close(FILE);
          }
	   # end of SLES8.1 support
        }else{ # for SuSE 
	   ArchiveUtils->mkLinks($realRPMS,"../../suse/*/*.rpm");
	   #end of SuSE support
	 }
    }# end of SuSE && SLES
    elsif($distro_name =~ /RedHat/){
    	 
	 ArchiveUtils->remove_all_links("$distro_top/RedHat");
	 ArchiveUtils->remove_all_links("$distro_top/RedHat/RPMS");
    	 
	 my $realRPMS = "$distro_top/RedHat/RPMS";
	 my $subDir = "";
	 if($sp ne undef){
		# link the RPMS from GA disks first
	 	my $orig_subdir = "$distro_name$distro_version-$arch";
		ArchiveUtils->mkLinks($realRPMS,"../../$orig_subdir/RedHat/RPMS/*.rpm");
		
	 	$subDir = "$distro_name$distro_version-$sp";
	 }else{
	 	$subDir = "$distro_name$distro_version-$arch";
	 }
	 
	 ArchiveUtils->mkLinks($realRPMS,"../../$subDir/RedHat/RPMS/*.rpm");
    	 
	 if(-e "$realRPMS/../../$subDir/RedHat/Updates")
	 {
		ArchiveUtils->mkLinks($realRPMS,"../../$subDir/RedHat/Updates/*.rpm");
	 }

    ArchiveUtils->mkLinks($distro_top,"$subDir/*");
    ArchiveUtils->mkLinks($distro_top,"$subDir/.*");
    ArchiveUtils->mkLinks("$distro_top/RedHat","../$subDir/RedHat/*");

    }

    if (($distro_name =~ /SuSE/) || ($distro_name =~ /SLES/))
    {
      if (-f "$distro_top/media.1/info.txt")
      {
        $cmd = "$::RM $distro_top/media.1/info.txt";
	NodeUtils->runcmd($cmd, 0);
      }
    }
    
    return;
}


sub copyDistroPkgs 
{
    my ($class,$arch,$distro_top, $distro_name,$distro_version,$sp) = @_;
    my ($cmd,$output,$orig_dir,$target,$ismounted,$pkghome);
    my ($progref,$progarg,$wrong_disk,$force_use_disk,$junk,$rc);
    
    my $platform = $::PLTFRM;
    if($arch =~ /i.86/) { $arch = "i386"; }

    my $orig_dir = getcwd();

    # Create the directory
    if (!(-e $distro_top))
    {
        $cmd = "$::MKDIR -p $distro_top;";
        $output = NodeUtils->runcmd($cmd, 0);
    }
       
    my @disks=();
    if(! defined($::pkgdefs{'distro_disks'}) )
    {
	 InstallUtils->get_pkgdefs($platform, $distro_name, $distro_version,$arch);  
    }
    
    my @orig_disks=@{$::pkgdefs{'distro_disks'}};
    
    if($sp eq ""){
	@disks = @orig_disks;
    }else{
	if($distro_name =~ /SLES/ && 
		!ArchiveUtils->is_req_disks_copied($distro_top,\@orig_disks))
	{
     		NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                  	 'csminstall', 'E1', 'EMsgReqOrigDisks');
		$rc = 0;
		goto done;
	}
    	if(defined $::pkgdefs{'sp_disks'}{$sp})
	{
		@disks=@{$::pkgdefs{'sp_disks'}{$sp}};
	}else{
		NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
			'csminstall', 'E1', 'EMsgBadServiceLevel',$sp);
		$rc = 0;
		goto done;
	}
    }

    if(scalar(@disks)<=0)
    {
	$rc = 0;
    	goto done;
    }
	
    my @pkgpath = ArchiveUtils->foundPkgPath("iso");
    my $images =  ArchiveUtils->probeImages(\@pkgpath,\@disks);
    
    foreach my $diskref(@disks){
    	my $diskname = $diskref->{name};
	my $disknum =  $diskref->{num};
	next if(defined($diskref->{not_for_full_install}));

	if(!defined $images->{$diskname}->{$disknum})
	{
	#
	# the disk is not included either in PKGPATH or iso files list.
	# try to search pkgs from cd
	#
		# Is it a wrong disk?
		$wrong_disk = 1;
		# Should force to use the disk?
		$force_use_disk = 0;
		
		while($wrong_disk && !$force_use_disk)
		{
			# Prompt insert disk
			NodeUtils->messageFromCat(
				'csmInstall.cat',  $::MSGMAPPATH,
				'csminstall',      'I',
				'IMsgINSERT_DISK', $diskname,
				$disknum
			);
			NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
				'csminstall', 'P', 'IMsgPRESS_ENTER');

			system "stty", '-icanon', 'eol', "\001";	
			$junk       = getc;
			system "stty", 'icanon', 'eol', '^@';

	        	# Mount the CD-ROM
			if ($platform eq "AIX")
                	{
                    		sleep(5);#this is needed for AIX and wont hurt Linux (too much)
                    		`$::UNMOUNT $::MNTCDROM 2>/dev/null 1>/dev/null`;
                    		InstallUtils->MountAixCdrom();
                	}
                	else
                	{
				# Check if MNTCDROM is already mounted
				$cmd = "$::MOUNT | $::GREP $::MNTCDROM";
                    		NodeUtils->runcmd("$cmd", -1);
                    		if ($::RUNCMD_RC)
                    		{
					if (-d $::MNTCDROM)
					{
						$cmd = "$::MOUNT $::MNTCDROM";
                    				# Ignore mount errors.  Usually they 
						# are because the CD was already mounted.
                    				NodeUtils->runcmd($cmd, -1);
					}else{
					# Print message when no MNTCDROM in system
					NodeUtils->messageFromCat('csmInstall.cat',$::MSGMAPPATH,'csminstall','E','EMsgNO_CDROM_DIRECTORY',$::MNTCDROM);
					}
				}
                	}

			# valid the disk if defined comp routine
			if(defined $diskref->{diskid_searchprog}){
			    $progref = $diskref->{diskid_searchprog};
			    $progarg = $diskref->{diskid_searchargs};
		        }else{
			    # suppose the inserted disk is correct if not defined 
			    # comp routine according to the orig logic
			    $wrong_disk = 0;
			    $ismounted  = 1;
			    $target = $::MNTCDROM;
			    next;
			}
			
			if( &$progref($::MNTCDROM,$progarg) )
			{
				$wrong_disk = 0;
				$target = $::MNTCDROM;
				$ismounted = 1;
				next;
			}else{
				# wrong disk, print a warning message		
                    		NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                	 'csminstall', 'W', 'EMsgWRONG_DISK', $diskname,
                                	 $disknum);
	                	NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                        		'csminstall', 'I', 'IMsgPRESS_ENTER_OR_FORCE');
                    		# Get user input

				system "stty", '-icanon', 'eol', "\001";
               	$junk = getc;
				system "stty", 'icanon', 'eol', '^@';
				print "\n";

		        	if ($junk eq "F" or $junk eq "f")
                    		{
					$force_use_disk = 1;
					$target = $::MNTCDROM;
					$ismounted = 1;
					next;
				}
 			}				
		} # end while($wrong_disk && $...)
	}else{
	#
	# the disk is included in either PKGPATH or iso files list
	#
		$target = $images->{$diskname}->{$disknum};
		
		# if the target is a iso image
		if( -f $target && $target=~/iso$/i ) 
		{
			$target = ArchiveUtils->mount_iso_image($target);
			if($target)
			{
				$ismounted = 1;
			}else{
				NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'I', 'IMsgCANT_MOUNT', $target);
				$ismounted = 0;
			}
		
		}
	}
	
        # Copy the contents of the Distro disk to /csminstall
        # Handle SLES 8.1
	  if($platform eq "Linux"){
		$pkghome=$distro_top ."/". $diskref->{diskid_target};
		if(! -d $pkghome){
		       $cmd = "$::MKDIR -p $pkghome";
		       NodeUtils->runcmd($cmd, -1);
		}
		$cmd =
		"$::TAR cf - -C $target . | $::TAR xvf - -C $pkghome; ";
	  }else{
       		$cmd = "$::TAR cf - -C $target . | $::TAR xvf - ";
	  }
	  
          NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
              'csminstall', 'I', 'IMsgCOPYING_DISK', $diskname, $disknum);

          $output  = NodeUtils->runcmd($cmd, 0);
	  &show_copy_progress($cmd,$target, $pkghome);

          # Unmount the CD-ROM if necessary
	  if($ismounted)
	  {
               if ($platform eq "AIX")
               {
           	    `$::UNMOUNT $target 2>/dev/null 1>/dev/null`;
               }
               else
               {
                    $cmd = "$::UNMOUNT $target > /dev/null 2>&1";
                    NodeUtils->runcmd("$cmd", -1);
               }		
	  }
    } # end foreach my $diskref...

    $rc = 1; # successfully :)

done:
    chdir($orig_dir);
    return $rc;
}

#--------------------------------------------------------------------------------

=head3    copyRpm

        Copies an rpm to a destination argument

        Arguments:
               $RpmFile,
               $Rpmpath,
               $destDir
        Returns:
                none
        Globals:
                none
        Error:
                exits on error from NodeUtils->run_cmd(...)
        Example:
                ArchiveUtils->copyRpm($basename, $path, $::INSTALLDIR_CSMINSTLP);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub copyRpm
{
    my ($class, $rpmfile, $path, $destination) = @_;
    NodeUtils->message("I", 'IMsgCOPYING', $rpmfile);

    mkpath($destination, $::VERBOSE, 0755);

    NodeUtils->run_cmd("$::COPY $path/$rpmfile $destination");
    NodeUtils->run_cmd("$::CHMOD +r $destination/$rpmfile");

    #If there are any errors during the copy or chmod, run_cmd() exits.
}

#--------------------------------------------------------------------------------

=head3 copy_rpm

        Copies the rpms using the @::Rpms_to_be_copied and @::Rpm_name_path hash

        Arguments:
                none

        Returns:
                none
        Globals:
                @::Rpms_to_be_copied
                %::Rpm_name_path

        Error:
                csmInstall.cat E1
        Example:
                ServerUtils->copy_rpm();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub copy_rpm
{
    foreach my $my_rpm (@::Rpms_to_be_copied)
    {
        my ($location, $destination, $full_name);

        $full_name   = $::Rpm_name_path{$my_rpm}{'BaseName'};
        $location    = $::Rpm_name_path{$my_rpm}{'Location'};
        $destination = $::Rpm_name_path{$my_rpm}{'Destination'};

        # test parameters
        if (
            !(
                  (defined($full_name))
               && (defined($location))
               && (defined($destination))
            )
          )
        {
            NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', 'E1', 'EMsgNoRpmFound',
                                      $my_rpm);
        }

        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'I', 'IMsgCOPYING', $full_name);

=head3 mmm - copy_rpm

	-----------------
	This disconnected block of code is being preserved in the file, rather than
	being removed.  It is a part of a change which is pending, which, due to the
	scale of the change, is being defered to a bac or brahms, where it will be
	evaluated and accepted or rejected. 
	-----------------

	# There may be an rpm, which is contained in an iso image file
	# and listed in Rpms_to_be_copied.  This filename would not be
	# in Rpm_name_path (by design for this fix). Check to see if the
	# rpm is in the RpmIndex as an "ISO".  If it is, then copy it
	# using RpmIndex otherwise, error out.

	if ( RpmIndex->in_iso_image ( $full_name ) == $::OK )
	{
		#print "copying $full_name in RpmIndex to $location\n";
		RpmIndex->copy ($full_name, $destination );
	}
        # need an else here 
 	# actually the logic is not quite there yet.
=cut

        my $cmd = "$::COPY $location/$full_name $destination";
        NodeUtils->runcmd("$cmd");

        $cmd = "$::CHMOD +r $destination/$full_name";
        NodeUtils->runcmd("$cmd");
    }
}

#--------------------------------------------------------------------------------

=head3 create_rpm_list_to_copy

        This subroutine will create a real hash of the rpms to be
        copied, by comparing their versions.  The final hash populated
        is %::Rpms_to_be_copied

        Arguments:
                none
        Returns:
                none
        Globals:
                %::temp_CmdLinePathVersionName
                $::PackageVersionName
                @::Rpms_to_be_copied
                (@::Rpms_not_found
                $::PackageVersionName
                $::PREREQS_ATTR{'OSName
                $::ATTRS
        Error:
                none
        Example:
                ServerUtils->create_rpm_list_to_copy();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub create_rpm_list_to_copy
{
    my (@my_rpm_array, @my_result);
    my $my_rpm_string;
    my @temp_RpmsNotFoundInCmdPath_array = ();
    foreach my $path (keys %::temp_CmdLinePathVersionName)
    {
        @my_rpm_array = ();
        foreach my $my_rpm (@{$::temp_CmdLinePathVersionName{$path}})
        {
            push(@my_rpm_array, ($path . "/" . $my_rpm));
        }
        $my_rpm_string = join(" ", @my_rpm_array);
        my $cmd =
          "$::RPMCMD -qp --qf '%{Name}::%{Version}::%{Release}::%{Arch}\n' $my_rpm_string";
        @my_result = NodeUtils->runcmd("$cmd", -1);
        foreach my $i (@my_result)
        {
            if (!($i =~ /.*::.*::.*::.*/))
            {
                if ($i =~ /warning/) { next; }
                else
                {
                    my @error_message = split(/\s+/, $i);
                    foreach my $p (@error_message)
                    {
                        if ($p =~ /\.rpm/)
                        {
                            my @full_path_name = split(/\//, $p);
                            foreach my $temp (@full_path_name)
                            {
                                if ($temp =~ /\.rpm/)
                                {
                                    my @rpm_full_name = split(/-/, $temp);
                                    my $rpm_name_base = shift(@rpm_full_name);
                                    NodeUtils->message('E1', 'EMsgInvalidRpm',
                                                       $rpm_name_base);
                                }
                            }
                        }
                    }
                }
            }
            my ($name, $version, $release, $arch) = split(/::/, $i);
            if (exists $::CmdLinePathVersionName{$arch})
            {
                if (exists $::CmdLinePathVersionName{$arch}{$name})
                {
                    my $ext_ver =
                      $::CmdLinePathVersionName{$arch}{$name}{'Version'};
                    my $ext_rel =
                      $::CmdLinePathVersionName{$arch}{$name}{'Release'};
                    if (
                        InstallUtils->testVersion(
                                    $version, ">=", $ext_ver, $release, $ext_rel
                        )
                      )
                    {
                        $::CmdLinePathVersionName{$arch}{$name}{'Version'} =
                          $version;
                        $::CmdLinePathVersionName{$arch}{$name}{'Release'} =
                          $release;
                        $::CmdLinePathVersionName{$arch}{$name}{'Location'} =
                          $path;
                        $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                          $name . "-" . $version . "-" . $release;
                    }
                }
                else
                {
                    $::CmdLinePathVersionName{$arch}{$name}{'Version'} =
                      $version;
                    $::CmdLinePathVersionName{$arch}{$name}{'Release'} =
                      $release;
                    $::CmdLinePathVersionName{$arch}{$name}{'Location'} = $path;
                    $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                      $name . "-" . $version . "-" . $release;
                }
            }
            else
            {
                $::CmdLinePathVersionName{$arch}{$name}{'Version'}  = $version;
                $::CmdLinePathVersionName{$arch}{$name}{'Release'}  = $release;
                $::CmdLinePathVersionName{$arch}{$name}{'Location'} = $path;
                $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                  $name . "-" . $version . "-" . $release;
            }
        }
    }

    # check for the result with the temp_CmdLinePathVersionName
    #foreach my $arch (%::CmdLinePathVersionName)
    #{
    #}

    #check the version and populate the to be copied hash and version not staisfied hash
    foreach my $arch (keys %::CmdLinePathVersionName)
    {
        if ($::COPY_OPT_FLAG)
        {

            #compare cm line vs defs
            foreach my $rpm_name (keys %{$::CmdLinePathVersionName{$arch}})
            {
                my $def_ver      = $::PackageVersionName{$rpm_name}{'Version'};
                my $def_rel      = $::PackageVersionName{$rpm_name}{'Release'};
                my $cmd_line_ver =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};
                my $cmd_line_rel =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};
                if (
                    InstallUtils->testVersion($cmd_line_ver, ">", $def_ver,
                                              $cmd_line_rel, $def_rel)
                  )
                {

                    #populate the copy hash
                    push(@::Rpms_to_be_copied, $rpm_name);
                }
                elsif (
                       InstallUtils->testVersion($cmd_line_ver, "=", $def_ver,
                                                 $cmd_line_rel, $def_rel)
                  )
                {

                    #populate the copy hash
                    push(@::Rpms_to_be_copied, $rpm_name);
                }
                else
                {

                    # error :rpm of the required version not found
                    push(@::Rpms_not_found, $rpm_name);
                }
            }
        }
        else
        {    #compare and populate the copy hash only necessary
                # First check against the command line and if the rpms are
                # found than  check the /csminstall.. directory
            foreach my $rpm_name (keys %{$::CmdLinePathVersionName{$arch}})
            {
                if (exists $::PathVersionName{$arch}{$rpm_name})
                {
                    my $def_ver = $::PackageVersionName{$rpm_name}{'Version'};
                    my $def_rel = $::PackageVersionName{$rpm_name}{'Release'};
                    my $cmd_line_ver =
                      $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};
                    my $cmd_line_rel =
                      $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};
                    my $path_ver =
                      $::PathVersionName{$arch}{$rpm_name}{'Version'};
                    my $path_rel =
                      $::PathVersionName{$arch}{$rpm_name}{'Release'};
                    if ($::CmdLinePathVersionName{$arch}{$rpm_name}{'Longname'}
                        eq $::PathVersionName{$arch}{$rpm_name}{'Longname'})
                    {

                        #compare:Cmd vs defs and populate the copy hash the rpm
                        if (
                            InstallUtils->testVersion(
                                                  $cmd_line_ver, ">=", $def_ver,
                                                  $cmd_line_rel, $def_rel)
                          )
                        {

                            #populate the copy hash
                            push(@::Rpms_to_be_copied, $rpm_name);
                            next;
                        }
                        else
                        {
                            push(@::Rpms_not_found, $rpm_name);
                            next;
                        }
                    }
                    else
                    {    #compare: command line vs path
                        if (
                            InstallUtils->testVersion(
                                                 $cmd_line_ver, ">=", $path_ver,
                                                 $cmd_line_rel, $path_rel)
                          )
                        {

                            #compare :cmd vs defs
                            if (
                                InstallUtils->testVersion(
                                                   $cmd_line_ver, ">=",
                                                   $def_ver,      $cmd_line_rel,
                                                   $def_rel
                                )
                              )
                            {

                                #populate the copy csm rpm
                                push(@::Rpms_to_be_copied, $rpm_name);
                                next;
                            }
                            else
                            {
                                push(@::Rpms_not_found, $rpm_name);
                                next;
                            }
                        }
                        else
                        {
                            if (
                                InstallUtils->testVersion(
                                                      $path_ver, ">=", $def_ver,
                                                      $path_rel, $def_rel)
                              )
                            {
                                next;
                            }
                            else
                            {
                                push(@::Rpms_not_found, $rpm_name);
                                next;
                            }
                        }
                    }
                }
                else
                {    # path doesn't exist
                    my $def_ver = $::PackageVersionName{$rpm_name}{'Version'};
                    my $def_rel = $::PackageVersionName{$rpm_name}{'Release'};
                    my $cmd_line_ver =
                      $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};
                    my $cmd_line_rel =
                      $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};
                    if (
                        InstallUtils->testVersion($cmd_line_ver, ">=", $def_ver,
                                                  $cmd_line_rel, $def_rel)
                      )
                    {

                        #populate the copy hash
                        push(@::Rpms_to_be_copied, $rpm_name);

                        # set value for ::PathVersionName Rick 2004 06 09
                        $::PathVersionName{$arch}{$rpm_name}{'Version'}  = $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};

                        $::PathVersionName{$arch}{$rpm_name}{'Release'}  = $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};

                        $::PathVersionName{$arch}{$rpm_name}{'Location'} = $::Rpm_name_path{$rpm_name}{'Destination'};

                        $::PathVersionName{$arch}{$rpm_name}{'Longname'} = $::CmdLinePathVersionName{$arch}{$rpm_name}{'Longname'};

                        next;
                    }
                    else
                    {
                        push(@::Rpms_not_found, $rpm_name);
                        next;
                    }
                }
            }
        }
    }
    if (   (scalar(@::Rpms_not_found) >= 1)
        || (scalar(@my_result) == 0)
        || (scalar(@::RpmsNotFoundInCmdPath) >= 1))
    {

        # check the /csminstall.. directory
        # gather the arch name and populate the valid arch array of
        # the PathVersionName hash depending on the os
        my (@my_temp_array, @valid_arch) = ();
        foreach my $arch (keys %::PathVersionName)
        {
            push(@my_temp_array, $arch);
        }
        if ($::PREREQS_ATTR{'OSName'} eq "AIX")
        {
            foreach my $arch (@my_temp_array)
            {
                if (($arch =~ /ppc/) || ($arch =~ /noarch/))
                {
                    push(@valid_arch, $arch);
                }
            }
        }
        elsif (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
               || ($::ATTRS{'InstallOSName'} eq "Linux"))
        {
            foreach my $arch (@my_temp_array)
            {
                if (   ($arch =~ /86/)
                    || ($arch =~ /ia64/)
                    || ($arch =~ /ppc64/)
                    || ($arch =~ /ppc/)
                    || ($arch =~ /noarch/))
                {
                    push(@valid_arch, $arch);
                }
            }
        }
        chomp(@valid_arch);
        my (%temp_hash) = ();

        # remove the number for the rpm name in the RpmsNotFoundInCmdPath variable
        foreach my $rpm_name_notfound (@::RpmsNotFoundInCmdPath)
        {
            my @parts = split /-/, $rpm_name_notfound;
            my $shortname = shift @parts;
            my $p;
          SNAME: while ($p = shift @parts)
            {
                if ($p !~ m/^\d/)
                {    #if it doesn't start with a digit
                    $shortname .= "-$p";
                }
                else { unshift @parts, $p; last SNAME; }
            }
            my $tmp_var1;
            my $my_rindex = rindex($shortname, "*");
            if ($my_rindex != -1)
            {
                $tmp_var1 = substr($shortname, 0, rindex($shortname, "*"));
            }
            else { $tmp_var1 = $shortname; }
            $my_rindex = rindex($tmp_var1, "-");
            if (($my_rindex + 1) == 0) { $shortname = $tmp_var1; }
            elsif (($my_rindex + 1) == length($tmp_var1))
            {
                $shortname = substr($tmp_var1, 0, rindex($tmp_var1, "*"));
            }
            push(@temp_RpmsNotFoundInCmdPath_array, $shortname);
        }
        @my_temp_array = (@::Rpms_not_found, @temp_RpmsNotFoundInCmdPath_array);
        @::Rpms_not_found =
          InstallUtils->get_uniqu_arry_elemnts(@my_temp_array);
        my @temp_not_found_rpm = ();
        @temp_not_found_rpm      = @::Rpms_not_found;
        @::Rpms_not_found        = ();
        @::RpmsNotFoundInCmdPath = ();
        my (@temp_array, @Rpmfound) = ();

        if (scalar(@valid_arch) <= 0)
        {
            @::Rpms_not_found = @temp_not_found_rpm;
        }
        foreach my $my_rpm (@temp_not_found_rpm)
        {
          PATHVER: foreach my $arch (@valid_arch)
            {
                if (exists $::PathVersionName{$arch}{$my_rpm})
                {
                    my $def_ver  = $::PackageVersionName{$my_rpm}{'Version'};
                    my $def_rel  = $::PackageVersionName{$my_rpm}{'Release'};
                    my $path_ver =
                      $::PathVersionName{$arch}{$my_rpm}{'Version'};
                    my $path_rel =
                      $::PathVersionName{$arch}{$my_rpm}{'Release'};
                    if (
                        InstallUtils->testVersion(
                                  $path_ver, ">=", $def_ver, $path_rel, $def_rel
                        )
                      )
                    {
                        my %temp_Rpmsfound_hash = ();
                        foreach my $my_Rpmfound (@::Rpmfound)
                        {
                            $temp_Rpmsfound_hash{$my_Rpmfound}++;
                        }
                        if (!exists($temp_Rpmsfound_hash{$my_rpm}))
                        {
                            push(@::Rpmfound, $my_rpm);
                            last PATHVER;
                        }
                        else { push(@::Rpms_not_found, $my_rpm); next PATHVER; }

                    }
                    else { push(@::Rpms_not_found, $my_rpm); next PATHVER; }
                }
                else { push(@::Rpms_not_found, $my_rpm); next PATHVER; }
            }
        }
        @::Rpms_not_found =
          InstallUtils->get_uniqu_arry_elemnts(@::Rpms_not_found);
        my %temp_Rpms_hash = ();
        foreach my $my_Rpmfound (@::Rpmfound)
        {
            $temp_Rpms_hash{$my_Rpmfound}++;
        }
        foreach my $my_rpm_notfound (@::Rpms_not_found)
        {
            if (!exists($temp_Rpms_hash{$my_rpm_notfound}))
            {
                push(@temp_array, $my_rpm_notfound);
            }
        }
        @::Rpms_not_found = @temp_array;
        @temp_array       = ();
        foreach my $my_rpm_notfound (@temp_RpmsNotFoundInCmdPath_array)
        {
            if (!exists($temp_Rpms_hash{$my_rpm_notfound}))
            {
                push(@temp_array, $my_rpm_notfound);
            }
        }
        @temp_RpmsNotFoundInCmdPath_array = @temp_array;

    }

    my %temp_hash = ();
    if (scalar(@::Rpms_to_be_copied) >= 1)
    {
        foreach my $rpm (@::Rpms_to_be_copied) { $temp_hash{$rpm}++; }
        foreach my $rpm (@temp_RpmsNotFoundInCmdPath_array)
        {
            if (!exists($temp_hash{$rpm})) { push(@::Rpms_not_found, $rpm); }
        }
        @::Rpms_not_found =
          InstallUtils->get_uniqu_arry_elemnts(@::Rpms_not_found);
    }
}

#--------------------------------------------------------------------------------

=head3 create_rpm_list_to_install

        Create the rpm list to be installed. The %::Rpms_to_be_installed hash
        the List of the rpms to be installed.  %::Rpms_already_installed hash
        has the list of rpms that are already been installed and
        %::RpmsNotFoundInCmdPath hash has the rpms list which are not found.

        Arguments:
                none
        Returns:
                none

        Globals:
                %::Rpms_to_be_installed
                %::Rpms_already_installe
                %::RpmsNotFoundInCmdPath
                $::CmdLinePathVersionName
                $::PackageVersionName_Server
        Error:
                none

        Example:
                ServerUtils->create_rpm_list_to_install();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub create_rpm_list_to_install
{
    my (@my_rpm_array, @my_result);
    my $my_rpm_string;
    foreach my $path (keys %::temp_CmdLinePathVersionName)
    {
        @my_rpm_array = ();
        foreach my $my_rpm (@{$::temp_CmdLinePathVersionName{$path}})
        {
            push(@my_rpm_array, ($path . "/" . $my_rpm));
        }
        $my_rpm_string = join(" ", @my_rpm_array);
        my $cmd =
          "$::RPMCMD -qp --qf '%{Name}::%{Version}::%{Release}::%{Arch}\n' $my_rpm_string";
        @my_result = NodeUtils->runcmd("$cmd", -1);
        foreach my $i (@my_result)
        {
            if (!($i =~ /.*::.*::.*::.*/)) { next; }
            my ($name, $version, $release, $arch) = split(/::/, $i);
            chomp($arch);
            if (exists $::CmdLinePathVersionName{$arch})
            {
                if (exists $::CmdLinePathVersionName{$arch}{$name})
                {
                    my $ext_ver =
                      $::CmdLinePathVersionName{$arch}{$name}{'Version'};
                    my $ext_rel =
                      $::CmdLinePathVersionName{$arch}{$name}{'Release'};
                    if (
                        InstallUtils->testVersion(
                                    $version, ">=", $ext_ver, $release, $ext_rel
                        )
                      )
                    {
                        $::CmdLinePathVersionName{$arch}{$name}{'Version'} =
                          $version;
                        $::CmdLinePathVersionName{$arch}{$name}{'Release'} =
                          $release;
                        $::CmdLinePathVersionName{$arch}{$name}{'Location'} =
                          $path;
                        $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                          $name . "-" . $version . "-" . $release;
                    }
                }
                else
                {
                    $::CmdLinePathVersionName{$arch}{$name}{'Version'} =
                      $version;
                    $::CmdLinePathVersionName{$arch}{$name}{'Release'} =
                      $release;
                    $::CmdLinePathVersionName{$arch}{$name}{'Location'} = $path;
                    $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                      $name . "-" . $version . "-" . $release;
                }    ##
            }
            else
            {
                $::CmdLinePathVersionName{$arch}{$name}{'Version'}  = $version;
                $::CmdLinePathVersionName{$arch}{$name}{'Release'}  = $release;
                $::CmdLinePathVersionName{$arch}{$name}{'Location'} = $path;
                $::CmdLinePathVersionName{$arch}{$name}{'Longname'} =
                  $name . "-" . $version . "-" . $release;
            }
        }
    }

    #check the version and populate the to be copied hash and version not staisfied hash
    foreach my $arch (keys %::CmdLinePathVersionName)
    {
        foreach my $rpm_name (keys %{$::CmdLinePathVersionName{$arch}})
        {
            if (exists $::rpmBasenames{$rpm_name})
            {
                my $def_ver =
                  $::PackageVersionName_Server{$rpm_name}{'Version'};
                my $def_rel =
                  $::PackageVersionName_Server{$rpm_name}{'Release'};
                my $path_ver =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};
                my $path_rel =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};
                my $exist_ver = $::rpmBasenames{$rpm_name}{'Version'};
                my $exist_rel = $::rpmBasenames{$rpm_name}{'Release'};
                if (
                    InstallUtils->testVersion(
                                  $path_ver, ">=", $def_ver, $path_rel, $def_rel
                    )
                  )
                {

                    if ($::CmdLinePathVersionName{$arch}{$rpm_name}{'Longname'}
                        eq $::rpmBasenames{$rpm_name}{'Longname'})
                    {
                        push(@::Rpms_already_installed, $rpm_name);
                        next;
                    }
                    elsif (
                           InstallUtils->testVersion($path_ver, ">", $exist_ver,
                                                     $path_rel, $exist_rel)
                      )
                    {
                        push(@::Rpms_to_be_installed, $rpm_name);
                        next;
                    }
                    elsif (
                           InstallUtils->testVersion(
                                                    $path_ver, "<=", $exist_ver,
                                                    $path_rel, $exist_rel)
                      )
                    {
                        push(@::Rpms_already_installed, $rpm_name);
                        next;
                    }
                }
                else
                {
                    if (
                        InstallUtils->testVersion(
                                $exist_ver, ">=", $def_ver, $exist_rel, $def_rel
                        )
                      )
                    {
                        push(@::Rpms_not_found_installed, $rpm_name);
                        next;
                    }
                    else
                    {
                        push(@::Rpms_not_found, $rpm_name);
                        next;
                    }
                }
            }
            else
            {

                # rpm not in the already installed list
                my $def_ver =
                  $::PackageVersionName_Server{$rpm_name}{'Version'};
                my $def_rel =
                  $::PackageVersionName_Server{$rpm_name}{'Release'};
                my $path_ver =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Version'};
                my $path_rel =
                  $::CmdLinePathVersionName{$arch}{$rpm_name}{'Release'};
                if (
                    InstallUtils->testVersion(
                                  $path_ver, ">=", $def_ver, $path_rel, $def_rel
                    )
                  )
                {
                    push(@::Rpms_to_be_installed, $rpm_name);
                    next;
                }
                else { push(@::Rpms_not_found, $rpm_name); next; }
            }
        }
    }
    my %temp_hash = ();
    if ($::FORCE_INSTALL)
    {
        @::Rpms_to_be_installed =
          (@::Rpms_to_be_installed, @::Rpms_already_installed);
        @::Rpms_already_installed = ();
    }
    foreach my $rpm (@::Rpms_to_be_installed) { $temp_hash{$rpm}++; }
    foreach my $rpm (@::RpmsNotFoundInCmdPath)
    {
        if (!exists($temp_hash{$rpm})) { push(@::Rpms_not_found, $rpm); }
    }
}

#--------------------------------------------------------------------------------

=head3    createRPMSdir

        Creates the proper /csminstall/.../RPMS directory structure 

        Arguments:
                $OS
                $distro_name
                $distro_version
                $arch

        Returns:
                undefined
        Globals:
                none
        Error:
                undefined

        Example:
                ServerUtils->createRPMSdir (   "Linux",
                                                $::DISTRO_NAME,
                                                $::DISTRO_VERSION,
                                                $::ARCH);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub createRPMSdir
{
    my ($class, $OS, $dist, $distver, $arch) = @_;
    use File::Path;    # Provides mkpath()

    my $base        = InstallUtils->getBaseDir($OS,     $dist, $distver, $arch);
    my $SMS_RPMS    = InstallUtils->getRPMSDir($OS,     $dist, $distver, $arch);
    my $SMS_updates = InstallUtils->getUpdateDir($OS,   $dist, $distver, $arch);
    my $SMS_install = InstallUtils->getInstallDir($OS,  $dist, $distver, $arch);
    my $realRPMS    = InstallUtils->getRealRPMSDir($OS, $dist, $distver, $arch);

    if (!-e "$base")
    {
        mkpath($base, $::VERBOSE, 0755);
    }
    if (!-e "$realRPMS")
    {
        mkpath($realRPMS, $::VERBOSE, 0755);
    }
    if (!-e "$SMS_updates")
    {
        mkpath($SMS_updates, $::VERBOSE, 0755);
    }
    if (!-e "$SMS_install")
    {
        mkpath($SMS_install, $::VERBOSE, 0755);
    }

    # Now we make new symbolic links to make sure they are
    # up to date
    if ($dist =~ /RedHat/)
    {

        #this is a symbolic link to ->RedHat/RPMS
        # force the change to make the symbolic link
        # relative, instead of full path.
        if (-d $SMS_RPMS)
        {

            #print "removing $SMS_RPMS\n";
            NodeUtils->runcmd("rm $SMS_RPMS");
        }

        #print "Now linking\n";
        #print "dir: $realRPMS\n";
        my $basedir = "$realRPMS/../../";
        my @pa      = split("/", $realRPMS);
        my $srcd    = pop @pa;
        $srcd    = pop(@pa) . "/" . $srcd;
        $basedir = join("/", @pa);

        #print "basedir: $basedir\nsrc: $srcd\n";
        my (undef, $target) = split("$basedir/", $SMS_RPMS);

        #print "target: $target\n";
        my $ln_cmd = "cd $basedir; $::LN -s $srcd $target";

        #print "LInk: $ln_cmd\n";
        NodeUtils->runcmd($ln_cmd, 0);
    }

    #SuSE Changes
    elsif ($dist =~ /SuSE/ || $dist =~ /SLES/)
    {
        if (-d $SMS_RPMS)
        {

            #print "removing $SMS_RPMS\n";
            NodeUtils->runcmd("rm $SMS_RPMS");
        }

        #print "Now linking\n";
        #print "dir: $realRPMS\n";
        my $basedir = "$realRPMS/../../";
        my @pa      = split("/", $realRPMS);
        my $srcd    = pop @pa;
        $srcd    = pop(@pa) . "/" . $srcd;
        $basedir = join("/", @pa);

        #print "basedir: $basedir\nsrc: $srcd\n";
        my (undef, $target) = split("$basedir/", $SMS_RPMS);

        #print "target: $target\n";
        my $ln_cmd = "cd $basedir; $::LN -s $srcd $target";

        #print "LInk: $ln_cmd\n";
        NodeUtils->runcmd($ln_cmd, 0);

        #End of SuSE Changes
    }
    else
    {
        mkpath($SMS_RPMS, $::VERBOSE, 0755);
    }
}

#--------------------------------------------------------------------------------

=head3    createRPMList

        Creates  a global hash of installed RPMS.


        Arguments:
                none


        Returns:
                none


        Globals:
                $::rpmShortnames
                $::rpmBasenames
        Error:
                undefined


        Example:
                ArchiveUtils->createRPMList();


        Comments:
                Subroutine must be called before checkRPMInstall.

=cut

#--------------------------------------------------------------------------------

sub createRPMList
{

    #first run rpm -qa to get a list of all rpms installed
    my @output = `$::RPMCMD -qa`;
    foreach my $line (@output)
    {
        chomp $line;
        $::rpmShortnames{$line} = 1;

        #now create the basename
        my @parts = split /-/, $line;
        my $basename = shift @parts;
        my $p;
      BNAME: while ($p = shift @parts)
        {
            if ($p !~ m/^\d/)
            {    #if it doesn't start with a digit
                $basename .= "-$p";
            }
            else
            {
                unshift @parts, $p;
                last BNAME;
            }
        }
        $::rpmBasenames{$basename} = 1;
    }

}

#--------------------------------------------------------------------------------

=head3    createRPMVersionListAlreadyInstalled

        Create a list(hash) of rpm's version, release and long name
        which are already been installed on the machine.  This
        routine can replace the routine createRPMList.  This routine
        also sets the variable which has been already used.


        Arguments:
                none
        Returns:
                undefined
        Globals:
                none
        Error:
                none


        Example:
                # determine if an rpm has already been installed
                ServerUtils->createRPMVersionListAlreadyInstalled(); 


        Comments:
                none_

=cut

#--------------------------------------------------------------------------------

sub createRPMVersionListAlreadyInstalled
{

    #first run rpm -qa to get a list of all rpms installed
    my @output =
      `$::RPMCMD -qa --qf '%{Name}::%{Version}::%{Release}::%{Arch}\n'`;
    chomp @output;
    my ($name, $version, $release, $arch);
    foreach my $line (@output)
    {
        chomp $line;
        ($name, $version, $release, $arch) = split(/::/, $line);
        my $longname = $name . "-" . $version . "-" . $release;
        $::rpmBasenames{$name}{'Version'}  = $version;
        $::rpmBasenames{$name}{'Release'}  = $release;
        $::rpmBasenames{$name}{'Longname'} = $longname;
        $::rpmBasenames{$name}{'Arch'}     = $arch;
        $::rpmShortnames{$longname}        = 1;
    }
}

#--------------------------------------------------------------------------------

=head3  createBatch  

        Groups the given nodes according to the fanout value.

        Arguments:
                $nodeList 
                $batchNodes 
                $fanout

        Returns:
                Fills $batchNodes.
        Globals:
                none    
        Error:
                undefined

        Example:
               my (@nodeList) = @_;
               my @batch = ();
               my $fanout = $ENV{'CSM_FANOUT'};
               if ($fanout eq '') { $fanout = $::DEFAULT_FANOUT; }
               ArchiveUtils->createBatch(\@nodeList, \@batch, $fanout); 

        Comments:

=cut

#--------------------------------------------------------------------------------
sub createBatch
{
    shift;
    my ($nodeList, $batchNodes, $fanout) = @_;
    my $length = @$nodeList;
    if ($length <= $fanout)
    {
        push(@$batchNodes, $nodeList);
    }
    else
    {

        #group them by the size of fanout value
        my $size = $fanout;
        my @batch;
        foreach my $node (@$nodeList)
        {
            push(@batch, $node);
            $size--;
            unless ($size)
            {
                my @newBatch = @batch;
                push(@$batchNodes, \@newBatch);
                $size  = $fanout;
                @batch = ();
            }
        }    #end of foreach
        if (@batch)
        {

            #last batch
            push(@$batchNodes, \@batch);
        }

    }    # end of else
}

#--------------------------------------------------------------------------------

=head3   displayProgress 

           Shows the %value of CD copy. This function is intended to be used by
           show_copy_progress subroutine.
        Arguments:
                 $lastFile 
                 $total 
                 $totalSize 
                 $isLastFile
        Returns:
                $total
        Globals:
               none
        Error:
                undefined

        Example:
               none

        Comments:  This function is intended to be used by show_copy_progress 
                   subroutine. 


=cut

#--------------------------------------------------------------------------------
sub displayProgress
{
    my ($lastFile, $total, $totalSize, $isLastFile) = @_;
    my @sizeString = ();
    my $size       = 0;
    @sizeString = NodeUtils->runcmd("du -a $lastFile", -1);
    my ($size) = split(/\s+/, $sizeString[0]);
    $size =~ s/^\s*//;    # Remove any leading whitespace
    $size =~ s/\s*$//;    # Remove any trailing whitespace
    if ($size =~ /\d+/)
    {
        $total = $total + $size;
        my $progress = int(($total / $totalSize) * 100);
        if ($progress > 100)
        {
            $progress = 100;
        }
        if ($isLastFile)
        {
            print("$progress% complete...\n");
        }
        else
        {
            print("$progress% complete...\r");
        }
    }    # end of else
    return $total;

}

#--------------------------------------------------------------------------------

=head3    findImagesInPath

        Find the images  in the given path.

        Arguments:
                $image
                @path

        Returns:
                @array of found $images in $path
        Globals:
                none    
        Error:
                undefined

        Example:
                 my @images =
                        ServerUtils->findImagesInPath($file, @::PKGPATH);

        Comments:
                The $image parameter can have a *, i.e. the routine
                can find more than one $image in the $path.

=cut

#--------------------------------------------------------------------------------

sub findImagesInPath
{

    # the $image variable may have a *, so we may find more than one that
    # matches.

    my ($class, $image, @path) = @_;
    my (@tmpImages, @returnImages, $tmpImage, $realImage);

    foreach my $p (@path)
    {
        my $filename = "$p/$image";

        # use the ls command here instead of the -e operator
        # so we can handle *s in the names

        if (`/bin/ls $filename 2> /dev/null`)
        {

            # put all of the images we just got into @tmpImages array
            chomp(@tmpImages = `/bin/ls $filename`);

            # Go through each tmpImage and see if the base name already
            # exists in the returnImages array.  If it does exist, don't
            # put it in, otherwise, put it in!

            foreach $tmpImage (@tmpImages)
            {

                # get the base name of the test image.

                my $tstImageBaseName;
                my $defined = 0;
                ($tstImageBaseName = $tmpImage) =~ s:^.*/::g;

                foreach $realImage (@returnImages)
                {

                    # get the base name of the real image

                    my $realImageBaseName;
                    ($realImageBaseName = $realImage) =~ s:^.*/::g;

                    if ($realImageBaseName eq $tstImageBaseName)
                    {
                        $defined = "true";
                        last;
                    }
                }

                unless ($defined)
                {
                    push @returnImages, $tmpImage;
                }
                else
                {

                    print "\n\nnot copying $tmpImage\n\n";
                }
            }
        }
    }
    return @returnImages;
}

#--------------------------------------------------------------------------------

=head3    findRpm

         Try to find and return the rpm file that is the required version.

        Arguments:
                 $pkg
                 $operator
                 $version
                 @my_pat
        Returns:
                Full package name of required rpm - as a string.
        Globals:
                @::VALID_DISTRO
                $::TFTPBOOT
                $::DISTRO_SHORTNAME
                $::DISTRO_RPMDIR
        Error:
                messageFromCat E11

        Example:
        my $newrpm =    InstallUtils->findRpm(    $pkg,
                            $operator,
                            $version,
                            @my_path);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub findRpm
{
    my ($class, $pkg, $operator, $version, @my_path) = @_;

    my $os_rpm_path  = $my_path[0];
    my $pkg_rpm_path = $my_path[1];
    if ($::PREREQS_ATTR{'OSName'} eq "Linux")
    {

        # Get the current distribution if it was not already obtained.
        my $distro = $::DISTRO;
        if (!$distro)
        {
            $distro =
                NodeUtils->get_DistributionName . " "
              . NodeUtils->get_DistributionVersion;
            if (!grep(/^$distro$/, @::VALID_DISTROS))
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                           'csminstall', 'W', 'EMsgUNSUPPORTED_DISTRO', $distro,
                           join(', ', @::VALID_DISTROS));
            }
            else
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                             'csminstall', 'V', 'IMsgDETECTED_DISTRO', $distro);
            }
        }
    }

    # note: The -vr options on the ls command gives us the entries in
    #       reverse version order to get the latest version first.
    my @rpms;
    my @rpms1;
    my @rpms2;

    # Look for the rpm in packages
    if (NodeUtils->isLinux)
    {
        @rpms1 = NodeUtils->runcmd("$::LS -vr $pkg_rpm_path/$pkg-*", -1);
    }
    else
    {
        @rpms1 = NodeUtils->runcmd("$::LS  $pkg_rpm_path/$pkg-*", -1);
    }
    my $rc1 = $::RUNCMD_RC;
    if (!$rc1) { @rpms = (@rpms, @rpms1); }    # Only add if no errors

    # Look for the rpm in  RPMS
    #my $TFTPBOOT_DISTRORPM = "$::TFTPBOOT/$::DISTRO_SHORTNAME{$distro}/$::DISTRO_RPMDIR{$distro}";
    if (NodeUtils->isLinux)
    {
        @rpms2 = NodeUtils->runcmd("$::LS -vr $os_rpm_path/$pkg-*", -1);
    }
    else
    {
        @rpms2 = NodeUtils->runcmd("$::LS $os_rpm_path/$pkg-*", -1);
    }
    my $rc2 = $::RUNCMD_RC;
    if (!$rc2) { @rpms = (@rpms, @rpms2); }    # Only add if no errors

    if (($rc1 && $rc2) || !scalar(@rpms)) { return undef; }

    foreach my $r (@rpms)
    {

        #my ($ipkg, $iversion, $irelease) = split('-', $r);
        my ($fn) = $r =~ m|^.*?([^/]+)$|;    # get rid of the directory, if any
                                             #print "fn=$fn\n";
        my ($ipkg, $iversion, $irelease) = $fn =~ /^(.+)-(\d.*)-(.*)$/;

        #print "ipkg=$ipkg, iversion=$iversion, irelease=$irelease\n";
        # Note: irelease has .i386.rpm on the end of it
        if ($ipkg ne $pkg || !length($iversion)) { next; }
        if (   !length($operator)
            || !length($version)
            || InstallUtils->testVersion($iversion, $operator, $version))
        {
            $operator = " " if (!$operator);
            $version  = " " if (!$version);

            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     'V',
                                      'IMsgFOUND',      $r,
                                      $operator,        $version
                                      );
            return $r;
        }
    }
    return undef;    # didn't find a suitable rpm

}

#--------------------------------------------------------------------------------

=head3    findRpmInPath

         Find the rpm package in the given path

        Arguments:
                $rpmPackageName
                @path

        Returns:
                Absolute path to rpm package. Package name is not
                returned with path value.

        Globals:
                none
        Error:
                none
        Example:
                $path =
                   ArchiveUtils->findRpmInPath($rpmfile, @my_path);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub findRpmInPath
{
    my ($class, $rpmfile, @path) = @_;
    foreach my $p (@path)
    {
        my $filename = "$p/$rpmfile";

        # use the ls command here instead of the -e operator so we can handle *s in the names
        #print "looking for $filename: ", `/bin/ls $filename`, "\n";
        if (`/bin/ls $filename 2> /dev/null`)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall',     'V',
                                      'IMsgFOUND_RPM',  $rpmfile,
                                      $p
                                      );
            return $p;
        }
    }

    return undef;
}

#--------------------------------------------------------------------------------

=head3 findRpmInPath_java

        Find the IBMJava rpm package in the given path 

        Arguments:
                $rpmFile
                @path

        Returns:
                rpm name as a string
                or undef.       
        Globals:
                none
        Error:
                none
        Example:
                $path =
                     ArchiveUtils->findRpmInPath_java ( $rpm_pre_file,
                                                        @full_PKGPATH );
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub findRpmInPath_java
{
    my ($class, $rpmfile, @path) = @_;
    foreach my $p (@path)
    {
        my $filename = "$p/$rpmfile";

        # use the ls command here instead of the -e operator so we can handle *s in the names
        if (`/bin/ls $filename 2> /dev/null`)
        {

            # process the rpm  name for the packager...
            my @outout =
              NodeUtils->runcmd(
                "$::RPMCMD -qp --qf '%{Name}::%{Version}::%{Release}::%{Arch}::%{Vendor}\n' $filename",
                -1
                );
            foreach my $i (@outout)
            {
                if (!($i =~ /.*::.*::.*::.*::.*/)) { next; }
                my ($name, $version, $release, $arch, $packager_name) =
                  split(/::/, $i);
                if (   ($packager_name =~ /International Business Machines/)
                    || ($packager_name =~ /UnitedLinux/))
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                              'csminstall', 'V', 'IMsgFOUND_RPM', $rpmfile, $p);
                    return $p;
                }
                else { next; }
            }
        }

=head3 mmm - findRpmInPath

	-----------------
	This disconnected block of code is being preserved in the file, rather than
	being removed.  It is a part of a change which is pending, which, due to the
	scale of the change, is being defered to a bac or brahms, where it will be
	evaluated and accepted or rejected. 
	-----------------

	# Check if rpmfile is in an iso image.  If we got here
	# we can assume that it will be in an iso image if it exists
	# in RpmIndex.  If in_iso is true, then return the path 
	# otherwise return undef.  When it gets copied we need to
	# be there to resolve any iso_image issues (ie mount and copy).

        # find keys matching $rpmfile wildcard string
        my $hash_ref = RpmIndex->defs_filter ( $rpmfile );
        my %ret_hash = %$hash_ref;

	 foreach my $arch ( keys %ret_hash)
	 {
	    my $array = @ret_hash { $arch };
	    foreach my $key ($array)
	    {
	    	if ( RpmIndex->in_iso_image ( $rpmfile ) == $::OK )
	    	{
                    my $ret_path = RpmIndex->path_filter ( $key );
		    #print "findRpmInPath: returning $ret_path \n";
	            return $ret_path;
	    	}
	   }
	}

=cut

    }
    return undef;
}

#--------------------------------------------------------------------------------

=head3    get_csminstall_pathVersion

        Get the version & release of the rpms in the /csminstall/{Linux|AIX} path.
        This routine will populate the PathVersionName hash

        Arguments:
                none

        Returns:
                undefined

        Globals:
                $::CSMINSTALLPATH_FLAG
                $::PREREQS_ATTR
                $::INSTALLDIR_CSMPKG
                $::INSTALLDIR_OS_NAME_RPMS
                $::PathVersionName
        Error:
                NodeUtills=->message E2

        Example:
                ServerUtils->get_csminstall_pathVersion();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_csminstall_pathVersion
{
    $::CSMINSTALLPATH_FLAG = 0;
    my ($my_path1, $my_path2);
    if (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
        || ($::ATTRS{'InstallOSName'} eq "Linux"))
    {
        $my_path1 = $::INSTALLDIR_CSMPKG;
        $my_path2 = $::INSTALLDIR_OS_NAME_RPMS;
        my (@my_rpms, @my_result, @my_temp_array) = ();
        my @my_path = ($my_path1, $my_path2);
        foreach my $mydir (@my_path)
        {
            opendir RPMDIR, $mydir;

            # use two temp files to handle each rpm file
            # only grep *.rpm files ( not . and .. files )
            my $myfile1 = "/tmp/csm_$$.1";
            my $myfile2 = "/tmp/csm_$$.2";
            open(TMPFILE1, ">$myfile1")
              || NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                          'csminstall', "E", 'EMsgCANT_WRITE_FILE', "$myfile1");
            while ($_ = readdir(RPMDIR))
            {
                my $file = "$mydir/$_";
                if ($file !~ /\.rpm$/) { next; }
                print TMPFILE1 "$file\n";
            }
            close TMPFILE1;
            if (-z $myfile1) { next; }
            my $cmd =
              "cat $myfile1 | xargs /bin/rpm -qp --qf '%{Name}::%{Version}::%{Release}::%{Arch}\n' > $myfile2";
            system($cmd);
            open(TMPFILE2, "<$myfile2")
              || NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                             'csminstall', 'E', 'EMsgCANT_READ_FILE', $myfile2);
            while (<TMPFILE2>)
            {
                my $k = $_;
                if (!($k =~ /.*::.*::.*::.*/)) { next; }
                my ($name, $version, $release, $arch) = split(/::/, $k);
                chomp($arch);

                # check if the arch exits
                if (exists $::PathVersionName{$arch})
                {

                    # check of the rpm already exits, if yes, than get the latest
                    if (exists $::PathVersionName{$arch}{$name})
                    {
                        my $ext_ver =
                          $::PathVersionName{$arch}{$name}{'Version'};
                        my $ext_rel =
                          $::PathVersionName{$arch}{$name}{'Release'};
                        if (
                            InstallUtils->testVersion(
                                    $version, ">=", $ext_ver, $release, $ext_rel
                            )
                          )
                        {
                            $::PathVersionName{$arch}{$name}{'Version'} =
                              $version;
                            $::PathVersionName{$arch}{$name}{'Release'} =
                              $release;
                            $::PathVersionName{$arch}{$name}{'Location'} =
                              $mydir;
                            $::PathVersionName{$arch}{$name}{'Longname'} =
                              $name . "-" . $version . "-" . $release;
                        }
                    }
                    else
                    {
                        $::PathVersionName{$arch}{$name}{'Version'}  = $version;
                        $::PathVersionName{$arch}{$name}{'Release'}  = $release;
                        $::PathVersionName{$arch}{$name}{'Location'} = $mydir;
                        $::PathVersionName{$arch}{$name}{'Longname'} =
                          $name . "-" . $version . "-" . $release;
                    }
                }
                else
                {
                    $::PathVersionName{$arch}{$name}{'Version'}  = $version;
                    $::PathVersionName{$arch}{$name}{'Release'}  = $release;
                    $::PathVersionName{$arch}{$name}{'Location'} = $mydir;
                    $::PathVersionName{$arch}{$name}{'Longname'} =
                      $name . "-" . $version . "-" . $release;
                }
            }
            close TMPFILE2;
            system("$::RM -f $myfile1");
            system("$::RM -f $myfile2");
            closedir RPMDIR;
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX")
    {
    }
    else { NodeUtils->message('E2', 'EMsgINVALID_OSTYPE'); }
}

#--------------------------------------------------------------------------------

=head3    get_definition_version

        Returns the version and release of the definition rpm/fileset
        which is defined in the defs file.

                I/P     - rpm name from the defs file
                O/P     - version and release delimited by "::"  

        Arguments:
                rpm definition file name

        Returns:
                the string: "$version::$release"

        Globals:
                none
        Error:
                undefined
        Example:
                 my($my_version, $my_release) =
                    split(/::/,ServerUtils->get_definition_version($tmp_var_rpm));
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_definition_version
{
    my ($class, $my_rpm_def) = @_;
    my ($req_ver,  $req_rel);
    my ($tmp_var1, $tmp_var2, $tmp_var3);

    #get the base name of the rpm
    my $my_rindex = rindex($my_rpm_def, "*");
    if ($my_rindex != -1)
    {
        $tmp_var1 = substr($my_rpm_def, 0, rindex($my_rpm_def, "*"));
    }
    else { $tmp_var1 = $my_rpm_def; }

    #get the version and release by processing the filename
    $my_rindex = rindex($tmp_var1, "-");
    if (($my_rindex + 1) == 0) { $req_ver = 0; $req_rel = 0; }
    else
    {
        $tmp_var2 = substr($tmp_var1, rindex($tmp_var1, "-") + 1);
        $tmp_var1 = substr($tmp_var1, 0, rindex($tmp_var1, "-"));
        $my_rindex = rindex($tmp_var1, "-");
        if ($my_rindex != -1)
        {
            $tmp_var3 = substr($tmp_var1, rindex($tmp_var1, "-") + 1);
            if (length($tmp_var2) > 0)
            {
                if ($tmp_var2 =~ /^[\d\.]*$/)
                {
                    if ($tmp_var3 =~ /^[\d\.]*$/)
                    {
                        $req_ver = $tmp_var3;
                        $req_rel = $tmp_var2;
                    }
                    else { $req_ver = $tmp_var2; $req_rel = 0; }
                }
                else { $req_ver = 0; $req_rel = 0; }
            }
            else { $req_ver = 0; $req_rel = 0; }
        }
        else
        {
            if (length($tmp_var2) > 0)
            {
                if ($tmp_var2 =~ /^[\d\.]*$/)
                {
                    $req_ver = $tmp_var2;
                    $req_rel = 0;
                }
                else { $req_ver = 0; $req_rel = 0; }
            }
            else { $req_ver = 0; $req_rel = 0; }
        }
    }
    my $return_str = $req_ver . "::" . $req_rel;
    return ($return_str);
}

#--------------------------------------------------------------------------------

=head3	getPackageList

	get packages lists

    Arguments:
        none
    Returns:
        # Lists of Open Source Packages that are required on the node
        @::opensrc_rpm_prereqs

        # Lists of packages that are part of each CSM component
        @::csm_packages

	# rsct client packages
        @::rsct_packages

	# director packages
        @::director_packages

        # Operating System Prereqs for Managed Nodes
        @::os_prereq

	@ package version name
        $::PackageVersionName

    Globals:
        see returns
    Error:
        multipl E1 msgs
    Example:
        ArchiveUtils->getPackageList();
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub getPackageList
{
    %::pkgdefs =
      ServerUtils->get_pkgdefs(
                               $::ATTRS{'InstallOSName'},
                               $::ATTRS{'InstallDistributionName'},
                               $::ATTRS{'InstallDistributionVersion'},
                               $::ATTRS{'InstallPkgArchitecture'},
                               'MgdNode',
                               $::ATTRS{'InstallCSMVersion'}
                               );

    if ($::ATTRS{'InstallOSName'} eq "AIX")
    {
        $::osTypeVersion =
          $::ATTRS{'InstallOSName'} . $::ATTRS{'InstallDistributionVersion'};
        $::INSTALLDIR       = "/csminstall";
        $::INSTALLDIR_CSM   = $::INSTALLDIR . "/csm";
        $::INSTALLDIR_CSMVR =
          $::INSTALLDIR_CSM . "/" . $::ATTRS{'InstallCSMVersion'};
        $::INSTALLDIR_CSMVRBIN = $::INSTALLDIR_CSMVR . "/bin";

        $::INSTALLDIR_OS    = $::INSTALLDIR . "/" . $::ATTRS{'InstallOSName'};
        $::INSTALLDIR_OSVER =
          $::INSTALLDIR_OS . "/" . $::ATTRS{InstallDistributionVersion};
        $::INSTALLDIR_OSCSM = $::INSTALLDIR_OS . "/csm";

        $::INSTALLDIR_CSMVER =
          $::INSTALLDIR_OSCSM . "/" . $::ATTRS{'InstallCSMVersion'};

        $::INSTALLDIR_CSMBIN    = $::INSTALLDIR_CSMVER . "/bin";
        $::INSTALLDIR_CSMPKG    = $::INSTALLDIR_CSMVER . "/packages";
        $::INSTALLDIR_CSMRPM    = $::INSTALLDIR_CSMPKG . "/rpms";
        $::INSTALLDIR_CSMINSTLP = $::INSTALLDIR_CSMPKG . "/installp";

        #
        # create package lists
        #

        # List of Open Source Packages that are required on the node
        my @mgdnode_open_srcrpms = (@{$::pkgdefs{opensrc_prereqs}});
        @::opensrc_rpm_prereqs = (@mgdnode_open_srcrpms);

        # Lists of packages that are part of each CSM component
        my @csm_client_packages = (@{$::pkgdefs{csm_packages}});
        @::csm_packages = (@csm_client_packages);

        my @rsct_client_packages = (@{$::pkgdefs{rsct_packages}});
        @::rsct_packages = (@rsct_client_packages);

        # Operating System Prereqs we need for Managed Nodes
        @::os_prereq = (@{$::pkgdefs{os_prereqs}});

    }
    elsif ($::ATTRS{'InstallOSName'} eq "Linux")
    {
        $::osTypeVersion =
            $::ATTRS{'InstallOSName'}
          . $::ATTRS{'InstallDistributionName'}
          . $::ATTRS{'InstallDistributionVersion'};
        $::INSTALLDIR       = "/csminstall";
        $::INSTALLDIR_CSM   = $::INSTALLDIR . "/csm";
        $::INSTALLDIR_CSMVR =
          $::INSTALLDIR_CSM . "/" . $::ATTRS{InstallCSMVersion};
        $::INSTALLDIR_CSMVRBIN = $::INSTALLDIR_CSMVR . "/bin";

        $::INSTALLDIR_OS =
            $::INSTALLDIR . "/"
          . $::ATTRS{"InstallOSName"} . "/"
          . $::ATTRS{'InstallDistributionName'};

        #/csminstall/Linux/RedHat
        $::INSTALLDIR_OSVER =
          $::INSTALLDIR_OS . "/" . $::ATTRS{InstallDistributionVersion};
        $::INSTALLDIR_OSVER_ARCH =
          $::INSTALLDIR_OSVER . "/" . $::ATTRS{'InstallPkgArchitecture'};

        $::INSTALLDIR_OSCSM  = $::INSTALLDIR_OS . "/csm";
        $::INSTALLDIR_CSMVER =
          $::INSTALLDIR_OSCSM . "/" . $::ATTRS{InstallCSMVersion};

        my $INSTALLDIR_OS_NAME = $::PREREQS_ATTR{DistributionName};
        if ($::PREREQS_ATTR{DistributionName} =~ /RedHat/)
        {
            $INSTALLDIR_OS_NAME = "RedHat";
        }
        $::INSTALLDIR_OS_NAME_RPMS =
          $::INSTALLDIR_OSVER_ARCH . "/" . $INSTALLDIR_OS_NAME . "/RPMS";

        #/csminstall/Linux/RedHat/7.3/i386/RedHat/RPMS
        $::INSTALLDIR_CSMBIN = $::INSTALLDIR_CSMVER . "/bin";
        $::INSTALLDIR_CSMPKG = $::INSTALLDIR_CSMVER . "/packages";

        #
        # create package lists
        #

        # Lists of Open Source Packages that are required on the node
        my @mgdnode_open_srcrpms = (@{$::pkgdefs{opensrc_prereqs}});
        @::opensrc_rpm_prereqs = (@mgdnode_open_srcrpms);

        # Lists of packages that are part of each CSM component
        my @csm_client_packages = (@{$::pkgdefs{csm_packages}});
        @::csm_packages = (@csm_client_packages);

        my @rsct_client_packages = (@{$::pkgdefs{rsct_packages}});
        @::rsct_packages = (@rsct_client_packages);

        # No need of  director if the OS is AIX
        if ($::PLTFRM eq "Linux")
        {
            @::director_packages = (@{$::pkgdefs{director_packages}});
        }
        else
        {
            @::director_packages = ();
        }

        # Operating System Prereqs for Managed Nodes
        @::os_prereq = (@{$::pkgdefs{os_prereqs}});

        foreach my $tmp_var_rpm (
                                 @::opensrc_rpm_prereqs, @::csm_packages,
                                 @::rsct_packages,       @::director_packages,
                                 @::os_prereq
          )
        {
            my ($my_version, $my_release) =
              split(/::/, ArchiveUtils->get_definition_version($tmp_var_rpm));
            my @parts = split /-/, $tmp_var_rpm;
            my $basename = shift @parts;
            my $p;
          BNAME: while ($p = shift @parts)
            {
                if ($p !~ m/^\d/)
                {    #if it doesn't start with a digit
                    $basename .= "-$p";
                }
                else { unshift @parts, $p; last BNAME; }
            }
            my $tmp_var1;
            my $my_rindex = rindex($basename, "*");
            if ($my_rindex != -1)
            {
                $tmp_var1 = substr($basename, 0, rindex($basename, "*"));
            }
            else { $tmp_var1 = $basename; }
            $my_rindex = rindex($tmp_var1, "-");
            if (($my_rindex + 1) == 0) { $basename = $tmp_var1; }
            elsif (($my_rindex + 1) == length($tmp_var1))
            {
                $basename = substr($tmp_var1, 0, rindex($tmp_var1, "*"));
            }
            else { $basename = $tmp_var1; }

            $::PackageVersionName{$basename}{'Version'}  = $my_version;
            $::PackageVersionName{$basename}{'Release'}  = $my_release;
            $::PackageVersionName{$basename}{'FullName'} = $tmp_var_rpm;
        }

    }
    else
    {
        MessageUtils->message("E2", 'EMsgINVALID_OSTYPE');
    }
}

#--------------------------------------------------------------------------------

=head3    get_PkgArchitecture

        Linux only routine.

        Returns the rpm package architure for the OS in $::PLTFRM
        i.e. i386 for linux

        Arguments:
                $output,
                $osarch
        Returns:
                none
        Globals:
                $::PLTFRM
        Error:
                messageFromCat E2

        Example:
                $::ATTRS{'InstallPkgArchitecture'} =
                        ServerUtils->get_PkgArchitecture;

        Comments:
                Works for Linux.  Returns null values $::PLTFRM
                is AIX, and exits with E2 for any other $::PLTFRM. 

=cut

#--------------------------------------------------------------------------------

sub get_PkgArchitecture
{
    my ($cmd, $output, $osarch);
    if ($::PLTFRM eq "Linux")
    {
        $cmd    = "$::UNAME -m";
        $output = NodeUtils->runcmd($cmd);
        chomp($output);

        $osarch = $output;

        return (length($osarch) ? $osarch : undef);
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $osarch = "";
        return (length($osarch) ? $osarch : undef);
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }
}

#--------------------------------------------------------------------------------

=head3    getRealRPMSDir

        Get the RPMS directory for the install attributes parameters

        Arguments:
                $InstallOSName
                $InstallDistributionName
                $InstallDistributionVersion
                $InstallPkgArchitectur

        Returns:
                appropriate path name for parameter values
        Globals:
                none
        Error:
                none
        Example:
                 my $realRPMS =
                    ArchiveUtils->getRealRPMSDir($OS, $dist, $distver, $arch);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getRealRPMSDir
{
    my ($class, $os, $distributor, $version, $arch) = @_;
    my $distro_dir = $distributor;
    if ($distributor =~ /RedHat/) { $distro_dir = "RedHat"; }
    if ($arch        =~ /i.86/)   { $arch       = "i386"; }
    return "/csminstall/$os/$distributor/$version/$arch/$distro_dir/RPMS";
}

#--------------------------------------------------------------------------------

=head3    getRecentVersionRpm

        Get the most recent version of the rpm argument.

        Arguments:
                $rpmName
        Returns:
                Recent RPM as a string
        Globals:
                none
        Error:
                none
        Example:
                $rpmfile =
                    ArchiveUtils->getRecentVersionRpm($path, $rpmFileName);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getRecentVersionRpm
{
    my ($class, $path, $rpm_name) = @_;

    my %localversions_hash = ();
    my %file_name_hash     = ();
    my %packver;
    my $rpm_basename;
    my $test_rpm_name;
    my $test_rpm_name_short;
    my @output = NodeUtils->runcmd("$::LS  -1 $path/$rpm_name");
    chomp @output;

    # Determine the basename of this rpm (strip off .arch.rpm)

    # %::PackageVersionName hash.  This code can handle an rpm
    # provided in these formats:
    #    rpmname
    #    rpmname*
    #    rpmname-*
    #    rpmname-**
    my (@test_rpm_split) = split(/\./, $rpm_name);
    my $splitpos = $#test_rpm_split - 2;
    $test_rpm_name = join('.', @test_rpm_split[0 .. $splitpos]);

    # Replace two *'s with one * (in case the rpm in pkgdefs already has a *)
    $test_rpm_name =~ s/\*\*$/*/;

    # Also, try stripping off the "*" or "-*" at the end
    $test_rpm_name_short = $test_rpm_name;
    $test_rpm_name_short =~ s/\*$//;
    $test_rpm_name_short =~ s/-$//;

    foreach my $r (keys %::PackageVersionName)
    {
        my $fullname = $::PackageVersionName{$r}{'FullName'};
        if (   ($fullname eq $test_rpm_name)
            or ($fullname eq $test_rpm_name_short))
        {
            $rpm_basename = $r;
            last;
        }
    }

=head3 mmm - getRecentVersionRpm

	-----------------
	This disconnected block of code is being preserved in the file, rather than
	being removed.  It is a part of a change which is pending, which, due to the
	scale of the change, is being defered to a bac or brahms, where it will be
	evaluated and accepted or rejected. 
	-----------------

    # it might be in an iso file

    if (!$rpm_basename)
    {
        #print "getRecentVersionRpm: rpm_basename not found using defs_filter.\n";

        my $hash_ref = RpmIndex->defs_filter ( $rpm_name );
        my %ret_hash = %$hash_ref;
	my $key;

	foreach my $arch ( keys %ret_hash ) 
	{
	     my @key_array = @ret_hash { $arch };
	     foreach $key ( @key_array )
	     {
                #print "found $key\n";
             }
            if (RpmIndex->in_iso_image($key) == $::OK )
            {
                #print "found $key to be in an iso  - returning it\n";
	        #$rpm_basename = $key;
		return $key;
            }
        }
    }

=cut

    if (!$rpm_basename)
    {

        #print "CANNOT FIND BASENAME FOR $rpm_name\n";
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',       $::MSGMAPPATH,
                                  'csminstall',           'E1',
                                  'EMsgPREREQ_NOT_FOUND', $rpm_name,
                                  $path
                                  );
        exit 1;
    }

    # if there is only one rpm with the same basename, then return that rpm name
    if (scalar(@output) == 1)
    {
        my ($fn) = $output[0] =~ m|^.*?([^/]+)$|;    # get rid of the directory.
              # Get the basename of the rpm found in the path or on the CD.
        my ($ipkg, $VERSION, $RELEASE) = $fn =~ /^(.+)-(\d.*)-(\d.*)\..+\..+$/;

        # The name of the RPM must match the basename of the rpm in pkgdefs
        if ($rpm_basename ne $ipkg)
        {

            #print "$rpm_basename DOES NOT MATCH $ipkg\n";
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',       $::MSGMAPPATH,
                                      'csminstall',           'E1',
                                      'EMsgPREREQ_NOT_FOUND', $rpm_basename,
                                      $path
                                      );
            exit 1;
        }
        return $output[0];
    }

    # If there are multiple RPMs with the same basename, then compare their
    # versions to see which is the latest.
    my $i = 0;
    foreach my $rpm1 (@output)
    {

        ####jcran changes start
        #### --getting the version from the output of LS, instead of running rpm multiple times

        # my $VERSION=NodeUtils->runcmd("$::RPMCMD -qp --qf '%{Version}' $rpm1");
        #my $VERSION=`rpm -qp --qf '%{Version}' $rpm1`;
        my ($fn) = $rpm1 =~ m|^.*?([^/]+)$|;  # get rid of the directory, if any
                                              #print "fn=$fn\n";
              #my ($ipkg, $VERSION) = $fn =~ /^(.+)-(\d.*)-.*$/;
        my ($ipkg, $VERSION, $RELEASE) = $fn =~ /^(.+)-(\d.*)-(\d.*)\..+\..+$/;

        ####jcran changes end

        chomp $VERSION;
        chomp $RELEASE;

        # The basename of the rpm must match the name given in pkgdefs
        if ($rpm_basename eq $ipkg)
        {
            $localversions_hash{$i}{'VERSION'}  = $VERSION;
            $localversions_hash{$i}{'RELEASE'}  = $RELEASE;
            $file_name_hash{$VERSION}{$RELEASE} = $rpm1;
            $i++;
        }
    }
    if ($i == 0)
    {

        #print "BASENAME DOES NOT MATCH NAME IN PKGDEFS FOR $rpm_basename\n";
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',       $::MSGMAPPATH,
                                  'csminstall',           'E1',
                                  'EMsgPREREQ_NOT_FOUND', $rpm_basename,
                                  $path
                                  );
        exit 1;

    }
    my $versionout = "";
    my $releaseout = "";
    $i = 0;
    foreach my $k (keys %localversions_hash)
    {
        if ($i == 0)
        {
            $versionout = $localversions_hash{$k}{'VERSION'};
            $releaseout = $localversions_hash{$k}{'RELEASE'};
        }
        if (
            InstallUtils->testVersion(
                                      $localversions_hash{$k}{'VERSION'},
                                      ">",
                                      $versionout,
                                      $localversions_hash{$k}{'RELEASE'},
                                      $releaseout
            )
          )
        {
            $versionout = $localversions_hash{$k}{'VERSION'};
            $releaseout = $localversions_hash{$k}{'RELEASE'};
        }
        $i++;

    }

    return ($file_name_hash{$versionout}{$releaseout});
}

#--------------------------------------------------------------------------------

=head3    getReqsNotSatisfied

        Return the rpms (and versions) that the given rpm requires that
        are not already on the system

        Arguments:
                $rpmPackageName
        Returns:
                Posibly empty array of rpm package names.
        Globals:
                none
        Error:
                none
        Example:
                 my @reqs =
                    ArchiveUtils->getReqsNotSatisfied($rpm);

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getReqsNotSatisfied
{
    my ($class, $rpm) = @_;
    my @requires;
    my @output = `LANG=C $::RPMCMD -i --test $rpm 2>&1`;
    my $RC     = $? >> 8;
    if ($RC == 0) { return @requires; }    # all dependencies were satisfied
    if ($RC > 1)  { return @requires; }
    my $firstline  = shift @output;
    my $secondline = $output[0];
    if ($firstline  =~ /is already installed/) { return @requires; }
    if ($secondline =~ /conflicts with/)       { return @requires; }
    if (!($firstline =~ /failed dependencies/)) { return @requires; }

    foreach my $o (@output)
    {

        #print "o=$o\n";
        my ($pkg, $operator, $version) = InstallUtils->parseRequire($o);

        #print "pkg=$pkg, operator=$operator, version=$version\n";
        if (!defined($pkg)) { next; }    # was not an rpm require

        # Hack for glibc version because I can not find a way to have the require
        # statement in the rpm be different for different distribution levels.
        if ($pkg eq 'glibc' && NodeUtils->distribution() =~ /^RedHat 7/i)
        {
            $o = "$pkg $operator 2.2";
        }

        my $req = "$pkg $operator $version";
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'V', 'IMsgREQUIRE', $rpm, $req);
        push(@requires, $req);
    }
    return @requires;
}

#--------------------------------------------------------------------------------

=head3    getRequiredRpms

        Return the names of any rpms that the rpm parameter depends on if
        they are not already on the system at the required level.

        The rpm passed in as the 1st arg is the complete rpm file name.
        The rest of the args are the list of reqs we have already found
        in previous, recursive invokations of the function.

        Arguments:
                $rpm
                @my_path

        Returns:
                @array of rpm dependancies for the $rpm argument

        Globals:
                none
        Error:
                messageFromCat E11

        Example:
                 my @reqs =
                   ArchiveUtils->getRequiredRpms($rpm, @my_path);

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getRequiredRpms
{
    my ($class, $rpm, @my_path) = @_;
    my @reqrpms;
    my @reqs = InstallUtils->getReqsNotSatisfied($rpm);

    #print "num=" . scalar(@reqs) . ' ,reqs=' . join(':', @reqs) . ".\n";
    foreach my $r (@reqs)
    {
        my ($pkg, $operator, $version) = split(' ', $r);

        my $newrpm = InstallUtils->findRpm($pkg, $operator, $version, @my_path);
        if (defined($newrpm))    # found an appropriate one to install
        {

            # make sure it is not already on the list
            if (grep(/^$newrpm$/, @_)) { next; }    # already on the list

            push @reqrpms, $newrpm;

            push @reqrpms,
              InstallUtils->getRequiredRpms($newrpm, @reqrpms, @my_path);
        }
        else
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E11',
                                      'EMsgCANT_FIND_RPM', $pkg,
                                      $operator,           $version,
                                      $rpm
                                      );
        }
    }
    return @reqrpms;
}

#--------------------------------------------------------------------------------

=head3    getRPMSDir

         Returns the RPMS directory (for SMS) for input params

        Arguments:
                $InstallOSName
                $InstallDistributionName
                $InstallDistributionVersion
                $InstallPkgArchitectur

        Returns:
                appropriate pathname for parameters
        Globals:
                none
        Error:
                none
        Example:
                 my $SMS_RPMS =
                    ArchiveUtils->getRPMSDir($OS, $dist, $distver, $arch);

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getRPMSDir
{
    my ($class, $os, $distributor, $version, $arch) = @_;
    if ($arch =~ /i.86/) { $arch = "i386"; }
    return "/csminstall/$os/$distributor/$version/$arch/RPMS";
}

#--------------------------------------------------------------------------------

=head3    getRPMVersionRelease

         Get RPM version and release if aviable.

        Arguments:
                $rpmPackageName
                $productFlag

        Returns:
                Rpm version and release as an array of two strings.
        Globals:
                none
        Error:
                E1 from csmInstallCat
        Example:
                (@temp_array) =
                   ArchiveUtils->getRPMVersionRelease($conserrpmfile, 1);

        Comments:
                $productFlag values are:
                   0 = already installed rpm or default
                   1 = product rpm

=cut

#--------------------------------------------------------------------------------

sub getRPMVersionRelease
{
    my (
        $cmd,   $version,  $release,      $my_str, $my_cmd,
        $class, $RPM_NAME, $product_flag, @my_array
        );
    @my_array     = ();
    $product_flag = 0;
    ($class, $RPM_NAME, $product_flag) = @_;
    if ($product_flag == 0)
    {
        $my_cmd = "$::RPMCMD -q --qf '%{Version}:|:%{Release}' $RPM_NAME";
        $my_str = NodeUtils->runcmd($my_cmd, -1);
    }
    else
    {
        $my_cmd = "$::RPMCMD -qp --qf '%{Version}:|:%{Release}' $RPM_NAME";
        $my_str = NodeUtils->runcmd($my_cmd, -1);
    }
    if ($::RUNCMD_RC != 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat', $::MSGMAPPATH,
                                  'csminstall',     'E1',
                                  'EMsgCANT_RUN',   $my_cmd,
                                  $::RUNCMD_RC
                                  );
    }
    ($version, $release) = split(/:\|:/, $my_str);
    push(@my_array, $version);
    push(@my_array, $release);
    return (@my_array);
}

#--------------------------------------------------------------------------------

=head3    installRequiredRpms

        Install any rpms that the rpm parameter is dependent on
        if they are not already on the system at the required level.

        Arguments:
                $rpmPkgName
                @path
        Returns:
                undefined
        Globals:
                $::FORCE_INSTALL
        Error:
                messageFromCat E11

        Example:
                ArchiveUtils->installRequiredRpms($rpmPkgFileName, @path);

        Comments:
                The rpm passed in is the whole rpm package name.

=cut

#--------------------------------------------------------------------------------

sub installRequiredRpms
{
    my ($class, $rpm, @my_path) = @_;
    my @reqs = InstallUtils->getRequiredRpms($rpm, @my_path);
    if (scalar(@reqs))    # need to install at least 1 rpm
    {
        my $reqlist = join(' ', @reqs);
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',          $::MSGMAPPATH,
                                  'csminstall',              'V',
                                  'IMsgINSTALLING_RPM_REQS', $rpm,
                                  $reqlist
                                  );
        my $cmd = "$::RPMCMD -U ";
        if ($::FORCE_INSTALL) { $cmd .= "--force "; }
        if ($::TEST)          { $cmd .= "--test "; }
        $cmd .= "$reqlist";
        NodeUtils->runcmd("$cmd");
    }

}

#--------------------------------------------------------------------------------

=head3    MountAixCdrom

         Mounts Aix Cdrom

        Arguments:
                none

        Returns:
                none

        Globals:
                $::AIX_MNT_DEV
                $::MNTCDROM
        Error:
                undefined
        Example:
                ServerUtils->MountAixCdrom();

        Comments:
                The caller should unmount the directory or cdrom before using
                this function. After using this subroutine, it is the
                responsibility of the caller to unmount the drive or directory.


=cut

#--------------------------------------------------------------------------------

sub MountAixCdrom
{

    use File::Path;    # Provides mkpath()
                       #$cmd = "$::MOUNT -v cdrfs -o ro /dev/cd0 $::MNTCDROM";
        #MOUNT_CMD="/usr/sbin/mount -rvcdrfs $DEVICE $2" -- mount command used

    if (!(-d $::MNTCDROM))
    {
        mkpath($::MNTCDROM, $::VERBOSE, 0755);
    }
    my $cmd = "$::MOUNT -rvcdrfs $::AIX_MNT_DEV $::MNTCDROM";
    NodeUtils->runcmd($cmd, 0);
    if ($::RUNCMD_RC)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E1', 'EMsgNO_MOUNT', $::MNTCDROM);
    }
}

#--------------------------------------------------------------------------------

=head3  mount_iso_image

	Tries to mount a file parameter as an ISO image file - a CD image as a
	file. The file is mounted to a predetermined mount point "/tmp_loop_mnt".

        Arguments:
                ISO image file including path from root.
        Returns:
                $::OK if mount worked
		$::NOK if not
        Globals:
                none
        Error:
		none
        Example:
                 my $rc = ArchiveUtils->mount_iso_image($file};
        Comments:
		$file parameter must include the path from root.
                

=cut

#--------------------------------------------------------------------------------

sub mount_iso_image
{
    my ($class, $file) = @_;

    # uses predefined mount point
    #my $mnt_point = "/tmp_loop_mnt";
    my $mnt_point = $::MNTCDROM;

    # futz with the mount point

    if (!(stat($mnt_point))[2])
    {

        # need to make the mount point
        my $cmd = "$::MKDIR -m 777 -p $mnt_point";
        my $rc = NodeUtils->runcmd($cmd, -1);    # no exit on error
        if (!($rc == 1)) { return $::NOK; }
    }

    my $cmd = "$::MOUNT -o loop $file $mnt_point";
    NodeUtils->runcmd($cmd, -1);    # no exit on error

    my $rc = $::RUNCMD_RC;

    if ($rc == 0) { return $mnt_point; }

    # umount in case the mount op worked, but cmd failed for some reason.
    my $cmd = "$::UMOUNT $mnt_point";
    NodeUtils->runcmd($cmd, -1);    # no exit on error

    return $::NOK;
}

#--------------------------------------------------------------------------------

=head3    parseRequire

        Parse a single require string, distinguishing between rpms
        and individual libraries of executables.

        Arguments:
                $requiredRpmString
        Returns:
                ($package, $operator, $version);
        Globals:
                none
        Error:
                none

        Example:
                my ($pkg, $operator, $version) =
                        ArchiveUtils->parseRequire($requiredRpmString);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub parseRequire
{
    my ($class, $line) = @_;
    $line =~ s/ is needed by .*$//;
    my ($pkg, $operator, $version, $therest) = split(' ', $line);
    if ($pkg =~ /^rpmlib/ || $pkg =~ m|/| || $pkg =~ /\.so/) { return undef; }
    else { return ($pkg, $operator, $version); }
}

#--------------------------------------------------------------------------------

=head3 search_copy_distro_rpms

        Check for the OS required rpms in tha path.

        If an rpm is not found then check the /csminstall.. directory.
        If the rpm is still not found, prompt for the OS CDs.

        If an rpm is found then add it to t$::temp_CmdLinePathVersionName
        and %::Rpm_name_path -  otherwise add it to %::RpmsNotFoundInCmdPath.

        Arguments:
                none
        Returns:
                none

        Globals:
                $::temp_CmdLinePathVersionName
                %::Rpm_name_path
                %::RpmsNotFoundInCmdPath
                @::Rpms_to_be_copied=();
                @::Rpms_not_found=();
                $::pkgdefs
                @::os_prereq
                $::command_line
                @::sis_packages
                $::Svrpkgdefs
                $::PREREQS_ATTR
                $::ATTRS
                $::PKGPATH
                $::DISTRO
                $::INSTALLDIR_OS_NAME_RPMS
        Error:
                none

        Example:
                ServerUtils->search_copy_distro_rpms();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub search_copy_distro_rpms
{
    if (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
        || ($::ATTRS{'InstallOSName'} eq "Linux"))
    {

        #if( $::DISTRO =~ /SLES/ || $::DISTRO =~/SuSE/ )
        #{
        #  NodeUtils->messageFromCat('csmInstall.cat',$::MSGMAPPATH,'csminstall','I','IMsgSearchAndCopy',"Distribution and SIS");
        #}
        #else
        #{
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'I', 'IMsgSearchAndCopy', "Distribution");

        #}
        my $distro      = $::DISTRO;
        my $destination = $::INSTALLDIR_OS_NAME_RPMS;
        my ($disk, $cmd, $rc);
        my (@notfound);
        my ($my_prereq, $prereq, $path, $dir);

        # First try to get the distro rpms out of the pkg path (which may
        # include the CSM CD).  This allows us to put newer versions of some
        # distro rpms on our media if we need to.
        # Note:  DISTRO_PREREQS is a hash of array references, thus the
        #        funny syntax below.
        my (@DISTRO_PKGPATH) = @::PKGPATH;

        #SuSE Changes
        if ($distro =~ /SLES/ || $distro =~ /SuSE/)
        {
            if ($::command_line =~ /copycsmpkgs/)
            {
                my @Temp = @DISTRO_PKGPATH;
                map { s|$|/$::pkgdefs{DISTRO_RPMDIR}/*| } @DISTRO_PKGPATH;
                if (   ($::pkgdefs{DISTRO_NAME} =~ /SLES/)
                    && ($::pkgdefs{DISTRO_NAME} =~ /8\.1/))
                {
                    map { s|$|/UnitedLinux/*| } @Temp;
                    @DISTRO_PKGPATH = (@DISTRO_PKGPATH, @Temp);
                }
            }
            else
            {
                my @Temp = @DISTRO_PKGPATH;
                map { s|$|/$::Svrpkgdefs{DISTRO_RPMDIR}/*| } @DISTRO_PKGPATH;
                if (($distro =~ /SLES/) && ($distro =~ /8\.1/))
                {
                    map { s|$|/UnitedLinux/*| } @Temp;
                    @DISTRO_PKGPATH = (@DISTRO_PKGPATH, @Temp);
                }
            }
        }
        else
        {
            if ($::command_line =~ /copycsmpkgs/)
            {
                map { s|$|/$::pkgdefs{DISTRO_RPMDIR}| } @DISTRO_PKGPATH;
            }
            else
            {
                map { s|$|/$::Svrpkgdefs{DISTRO_RPMDIR}| } @DISTRO_PKGPATH;
            }
        }
        @DISTRO_PKGPATH = (@DISTRO_PKGPATH, @::PKGPATH);

        #Empty the the hashes already used
        %::temp_CmdLinePathVersionName = ();
        %::Rpm_name_path               = ();
        %::CmdLinePathVersionName      = ();
        @::Rpms_to_be_copied           = ();
        @::Rpms_not_found              = ();
        @::RpmsNotFoundInCmdPath       = ();

        # Determine the RPM architectures to search for on each platform.
        my @archs;
        my $arch = $::PREREQS_ATTR{'PkgArchitecture'};
        if (!$arch) { $arch = $::ATTRS{'InstallPkgArchitecture'}; }

        if ($arch =~ /i.86/)
        {
            @archs = ('i?86', 'noarch');
        }
        elsif ($arch =~ /ppc64/)
        {
            @archs = ($arch, 'ppc', 'noarch');
        }
        elsif ($arch =~ /x86_64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        elsif ($arch =~ /ia64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        else    # Any other unknown architectures.
        {
            @archs = ($arch, 'noarch');
        }

        #foreach $prereq (@::os_prereq, @::sis_packages)
        foreach $prereq (@::os_prereq)
        {

            NodeUtils->message('V', 'IMsgSEARCHING_FOR_PREREQ', $prereq);
            $my_prereq = '';
            $path      = '';
            foreach my $a (@archs)
            {
                if (!($path))
                {
                    $my_prereq = "${prereq}.$a.rpm";
                    $path      =
                      InstallUtils->findRpmInPath($my_prereq, @DISTRO_PKGPATH);
                }
                else { last; }
            }

            if (defined($path))
            {

                # Get the latest version of the file in the first location found
                my $rpm_pre_file =
                  InstallUtils->getRecentVersionRpm($path, $my_prereq);

                chomp $rpm_pre_file;

                my $rpmfile_basename;
                ($rpmfile_basename = $rpm_pre_file) =~ s:^.*/::g;

                #find the shortname
                my @parts = split /-/, $rpmfile_basename;
                my $shortname = shift @parts;
                my $p;

              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }

                push @{$::temp_CmdLinePathVersionName{$path}},
                  $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'BaseName'}    = $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'Location'}    = $path;
                $::Rpm_name_path{$shortname}{'Destination'} = $destination;
            }
            else
            {

                #get the shortname of the rpm
                my @parts = split /-/, $prereq;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }
                my $tmp_var1;
                my $my_rindex = rindex($shortname, "*");
                if ($my_rindex != -1)
                {
                    $tmp_var1 = substr($shortname, 0, rindex($shortname, "*"));
                }
                else { $tmp_var1 = $shortname; }
                $my_rindex = rindex($tmp_var1, "-");
                if (($my_rindex + 1) == 0) { $shortname = $tmp_var1; }
                elsif (($my_rindex + 1) == length($tmp_var1))
                {
                    $shortname = substr($tmp_var1, 0, rindex($tmp_var1, "*"));
                }
                else { $shortname = $tmp_var1; }
                push(@::RpmsNotFoundInCmdPath, $shortname);

                #push(@::RpmsNotFoundInCmdPath,$prereq);
            }
        }
        my @temp_array2 = ();

        #copy the pacakges found in the path
        InstallUtils->create_rpm_list_to_copy();

        foreach my $my_rpm_name (@::Rpms_not_found)
        {
            push(@temp_array2, $::PackageVersionName{$my_rpm_name}{'FullName'});
        }

        @notfound = @temp_array2;
        InstallUtils->copy_rpm();

        # return if all the packages are found
        if (!scalar(@notfound)) { return; }

        # if the packages are not found in the path than check in the
        # /csminstall.. directory if the copy flag is not set

        # Copy RPMs from distribution CD-ROM(s)
        $cmd = "$::UNMOUNT $::MNTCDROM > /dev/null 2>&1";
        NodeUtils->runcmd("$cmd", -1);

        #NodeUtils->run_cmd($cmd, "W", "ignore_errors");
        #my $my_DISTRO_DISKLIST;
        my $my_DISTRO_NAME;
        my $my_DISTRO_RPMDIR;
        #my @disks;
        my @all_disks;
        if ($::command_line =~ /copycsmpkgs/)
        {

            #$my_DISTRO_DISKLIST=$::pkgdefs{DISTRO_DISKLIST};
            push( @all_disks , $::pkgdefs{'distro_disks'} );
	    if($distro =~ /RedHat/)
            {
                foreach my $obj (keys %{$::pkgdefs{'sp_disks'}})
	        {
		    if(scalar(@{$::pkgdefs{'sp_disks'}{$obj}})>0)
	            { push (@all_disks , $::pkgdefs{'sp_disks'}{$obj}); }
	        }
            }
            $my_DISTRO_NAME   = $::pkgdefs{DISTRO_NAME};
            $my_DISTRO_RPMDIR = $::pkgdefs{DISTRO_RPMDIR};
        }
        else
        {
            #$my_DISTRO_DISKLIST=$::Svrpkgdefs{DISTRO_DISKLIST};
	    #@disks            = (@{$::Svrpkgdefs{'distro_disks'}});
            push( @all_disks , $::Svrpkgdefs{'distro_disks'} );
	    if($distro =~ /RedHat/)
            {
                foreach my $obj (keys %{$::Svrpkgdefs{'sp_disks'}})
	        {
		    if(scalar(@{$::Svrpkgdefs{'sp_disks'}{$obj}})>0)
	            { push (@all_disks , $::Svrpkgdefs{'sp_disks'}{$obj}); }
	        }
            }
            $my_DISTRO_NAME   = $::Svrpkgdefs{DISTRO_NAME};
            $my_DISTRO_RPMDIR = $::Svrpkgdefs{DISTRO_RPMDIR};
        }

        my $first_disk = 0;
        
	my @disks = @{$all_disks[0]};
	
	foreach my $diskref (@disks)
        {
            my $diskname = $diskref->{name};
            my $disknum  = $diskref->{num};

            #Empty the the hashes already used
            %::temp_CmdLinePathVersionName = ();
            %::Rpm_name_path               = ();
            %::CmdLinePathVersionName      = ();
            @::Rpms_to_be_copied           = ();
            @::Rpms_not_found              = ();
            @::RpmsNotFoundInCmdPath       = ();

            NodeUtils->message('I', 'IMsgINSERT_DISK', $diskname, $disknum);

            NodeUtils->message('P', 'IMsgPRESS_ENTER');
            
            #my $junk = getc;
			system "stty", '-icanon', 'eol', "\001";
           	my $junk = getc;
			system "stty", 'icanon', 'eol', '^@';

            my $wrong_disk = 1;
	    
            while ($wrong_disk)
            {

                # Mount the CD-ROM
                if ($::PLTFRM eq "AIX")
                {
                    sleep(5);    #this is needed for AIX
                    `$::UNMOUNT $::MNTCDROM 2>/dev/null 1>/dev/null`;
                    InstallUtils->MountAixCdrom();
                }
                else
                {
		    # Check if MNTCDROM is already mounted
		    $cmd = "$::MOUNT | $::GREP $::MNTCDROM";
		    NodeUtils->runcmd("$cmd", -1);
		    if ($::RUNCMD_RC)
		    {	
		    	if (-d $::MNTCDROM)
			{
			    	$cmd = "$::MOUNT $::MNTCDROM";

                    		# Ignore mount errors.  Usually they are because
                    		# the CD was already mounted.
                    		NodeUtils->runcmd("$cmd", -1);
			}else{
			# Print message when no MNTCDROM in system
		  	NodeUtils->messageFromCat('csmInstall.cat',$::MSGMAPPATH,'csminstall','E','EMsgNO_CDROM_DIRECTORY',$::MNTCDROM);
			}
		    }
                }

                # Check for valid disk inserted
                if (defined $diskref->{diskid_searchprog})
                {
                    my $progref = $diskref->{diskid_searchprog};
                    my $progarg = $diskref->{diskid_searchargs};
                    $wrong_disk = !(&$progref($::MNTCDROM, $progarg));
                    goto check_over;
                }

                # Save the original logic for compatiable with old pkgdefs
                my $diskid_searchstring = $diskref->{diskid_searchstring};
                my $diskid_filename     =
                  "$::MNTCDROM/" . $diskref->{diskid_filename};
                $cmd = "$::LS $diskid_filename 2> /dev/null";
                chomp($diskid_filename = NodeUtils->runcmd($cmd, -1));

                # First make sure the file exists
                if (!$::RUNCMD_RC and -f $diskid_filename)
                {
                    if ($diskid_searchstring)
                    {
                        open(DISKID_FILE, $diskid_filename)
                          || NodeUtils->message('E', 'EMsgCANT_READ_FILE',
                                                $diskid_filename);
                        if (grep (/$diskid_searchstring/, <DISKID_FILE>))
                        {

                            #print "CORRECT DISK!\n";
                            $wrong_disk = 0;
                        }
                        else
                        {

                            #print "Search string $diskid_searchstring not found\n";
                            $wrong_disk = 1;
                        }
                        close DISKID_FILE;
                    }
                    else { $wrong_disk = 0; }
                }
                else
                {

                    #print "Can't find $::MNTCDROM/$diskref->{diskid_filename}.  \nERRORS:  $diskid_filename\n";
                    $wrong_disk = 1;
                }

              check_over:
                if ($wrong_disk)
                {
		    if($first_disk==0)
                    {
                         foreach my $disc (@all_disks)
                         {
                             my $diskref = $disc->[0];
                             my $progref = $diskref->{diskid_searchprog};
                             my $progarg = $diskref->{diskid_searchargs};
                             if(&$progref($::MNTCDROM, $progarg))
                             {
                                  @disks = @$disc;
                                  goto move_on;
                             }
                         }
                    }
		    
                    if ($::PLTFRM eq "AIX")
                    {
                        `$::UNMOUNT $::MNTCDROM 2>/dev/null 1>/dev/null`;
                    }
                    else
                    {
                        $cmd = "$::UNMOUNT $::MNTCDROM > /dev/null 2>&1";
                        NodeUtils->runcmd("$cmd", -1);
                    }
                    NodeUtils->message('W', 'EMsgWRONG_DISK', $diskname,
                                       $disknum);
                    NodeUtils->message('I', 'IMsgINSERT_DISK', $diskname,
                                       $disknum);

                    NodeUtils->message('P', 'IMsgPRESS_ENTER_OR_FORCE');

                    # Get user input
                    #$junk = getc;
				system "stty", '-icanon', 'eol', "\001";
               	$junk = getc;
				system "stty", 'icanon', 'eol', '^@';
				print "\n";

                    if ($junk eq "F" or $junk eq "f")
                    {

                        #Force it to be the right disk
                        # Mount the CD-ROM
                        if ($::PLTFRM eq "AIX")
                        {
                            `$::UNMOUNT $::MNTCDROM 2>/dev/null 1>/dev/null`;
                            InstallUtils->MountAixCdrom();
                        }
                        else
                        {
			    # Check if MNTCDROM is already mounted
			    $cmd = "$::MOUNT | $::GREP $::MNTCDROM";
			    NodeUtils->runcmd("$cmd", -1);
			    if ($::RUNCMD_RC)
			    {
				if (-d $::MNTCDROM)
				{
				    	$cmd = "$::MOUNT $::MNTCDROM";
				# Ignore mount errors.  Usually they are because
				## the CD was already mounted.
					NodeUtils->runcmd($cmd, -1);
				}else{
				# Print message when no MNTCDROM in system
			    NodeUtils->messageFromCat('csmInstall.cat',$::MSGMAPPATH,'csminstall','E','EMsgNO_CDROM_DIRECTORY',$::MNTCDROM);
			    	}
			    }
                        }
                        $wrong_disk = 0;
                    }
                    else
                    {

                        # Try again
                        next;
                    }
                }
            }

move_on:

            $first_disk++;

            # Determine the RPM architectures to search for on each platform
            # and determine the directory to search for RPMs on each CD.
            my @archs;
            my $arch = $::PREREQS_ATTR{'PkgArchitecture'};
            if (!$arch) { $arch = $::ATTRS{'InstallPkgArchitecture'}; }

            if ($arch =~ /i.86/)
            {
                @archs = ('i?86', 'noarch');

                if (($distro =~ /SLES/) && ($distro =~ /8\.1/))
                {

                    # See if this is the SLES disk (not the UnitedLinux disk)
                    if ($disknum eq '1' and $diskname =~ /$my_DISTRO_NAME/)
                    {
                        $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                    }
                    else
                    {
                        $dir = "$::MNTCDROM/UnitedLinux/*";
                    }
                }
                elsif (($distro =~ /SuSE/) || ($distro =~ /SLES/))
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                }
                else
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR";
                }
            }
            elsif ($arch =~ /ppc64/)
            {
                @archs = ($arch, 'ppc', 'noarch');

                if (($distro =~ /SuSE/) || ($distro =~ /SLES/))
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                }
                else
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR";
                }
            }
            elsif ($arch =~ /x86_64/)
            {
                @archs = ($arch, 'i?86', 'noarch');

                if (($distro =~ /SLES/) && ($distro =~ /8\.1/))
                {

                    # See if this is the SLES disk (not the UnitedLinux disk)
                    if ($disknum eq '1' and $diskname =~ /$my_DISTRO_NAME/)
                    {
                        $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                    }
                    else
                    {
                        $dir = "$::MNTCDROM/UnitedLinux/*";
                    }
                }
                elsif (($distro =~ /SuSE/) || ($distro =~ /SLES/))
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                }
                else
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR";
                }
            }
            elsif ($arch =~ /ia64/)
            {
                @archs = ($arch, 'i?86', 'noarch');

                if (($distro =~ /SLES/) && ($distro =~ /8\.1/))
                {

                    # See if this is the SLES disk (not the UnitedLinux disk)
                    if ($disknum eq '1' and $diskname =~ /$my_DISTRO_NAME/)
                    {
                        $dir = "$::MNTCDROM/my_DISTRO_RPMDIR/*";
                    }
                    else
                    {
                        $dir = "$::MNTCDROM/UnitedLinux/*";
                    }
                }
                elsif (($distro =~ /SuSE/) || ($distro =~ /SLES/))
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR/*";
                }
                else
                {
                    $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR";
                }
            }
            else    # Any other unknown architectures.
            {
                @archs = ($arch, 'noarch');
                $dir = "$::MNTCDROM/$my_DISTRO_RPMDIR";
            }

            foreach $prereq (@notfound)
            {

                $my_prereq = '';
                $path      = '';
                if (!length($prereq)) { next; }    # already found that one
                NodeUtils->message('V', 'IMsgSEARCHING_FOR_PREREQ_ON_CD',
                                   $prereq, $disknum);
                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $my_prereq = "${prereq}.$a.rpm";
                        $path = InstallUtils->findRpmInPath($my_prereq, $dir);

                        if (
                            !($path)
                            && ($::pkgdefs{DISTRO_NAME} =~
                                /Red Hat Enterprise Linux AS 3 PPC/)
                          )
                        {
                            my $updatesdir =
                              "$::MNTCDROM/$::pkgdefs{DISTRO_UPDATESDIR}";
                            $path =
                              InstallUtils->findRpmInPath($my_prereq,
                                                          $updatesdir);
                        }
                    }
                    else { last; }
                }

                if (defined($path))
                {

                    # Get the latest version of the file in the first location found
                    #my $rpm_pre_file = NodeUtils->runcmd("$::LS -vr $path/$my_prereq | $::HEAD -1", -1);
                    my $rpm_pre_file =
                      InstallUtils->getRecentVersionRpm($path, $my_prereq);

                    chomp $rpm_pre_file;
                    my $rpmfile_basename;
                    ($rpmfile_basename = $rpm_pre_file) =~ s:^.*/::g;

                    #find the shortname
                    my @parts = split /-/, $rpmfile_basename;
                    my $shortname = shift @parts;
                    my $p;
                  SNAME: while ($p = shift @parts)
                    {
                        if ($p !~ m/^\d/)
                        {    #if it doesn't start with a digit
                            $shortname .= "-$p";
                        }
                        else { unshift @parts, $p; last SNAME; }
                    }
                    push @{$::temp_CmdLinePathVersionName{$path}},
                      $rpmfile_basename;
                    $::Rpm_name_path{$shortname}{'BaseName'} =
                      $rpmfile_basename;
                    $::Rpm_name_path{$shortname}{'Location'}    = $path;
                    $::Rpm_name_path{$shortname}{'Destination'} = $destination;
                    $prereq = '';    # so we do not search for it on the next cd
                }
            }

            # copy the rpm collected from the cd
            InstallUtils->create_rpm_list_to_copy();
            my $nf =
              join(' ', @notfound);    # this eliminates the ones we blanked out
            @notfound = split(' ', $nf);

            if (scalar(@::Rpms_not_found) >= 1)
            {
                @notfound = (@notfound, @::Rpms_not_found);
            }
            @::Rpms_not_found = ();
            InstallUtils->copy_rpm();

            # return if all the packages are found
            if (!scalar(@notfound)) { last; } # do not need to go to the next cd

            $cmd = "$::UNMOUNT $::MNTCDROM > /dev/null 2>&1";
            NodeUtils->runcmd("$cmd", -1);
        }

        # make sure to unmount cdrom after copying all the rpms
        $cmd = "$::UNMOUNT $::MNTCDROM > /dev/null 2>&1";
        NodeUtils->runcmd("$cmd", -1);

        #NodeUtils->run_cmd($cmd, "W");

        # Ignore all SIS packages
        my $rpm_temp;
        my (@ignore_temp);
        my (@notfound_temp);
        foreach $rpm_temp (@notfound)
        {
            my $short_rpm;
            my $my_rindex = rindex($rpm_temp, "*");
            if ($my_rindex != -1)
            {
                $short_rpm = substr($rpm_temp, 0, $my_rindex);
            }

            #my @foo = grep(/$short_rpm/, @::sis_packages);
            #if (scalar(@foo)) {
            #    push (@ignore_temp,$rpm_temp);
            #}
            #else {
            push(@notfound_temp, $rpm_temp);

            #}
        }

        if (scalar(@ignore_temp))
        {
            NodeUtils->message('I', 'IMsgMissingRPM', join(", ", @ignore_temp));
        }
        if (scalar(@notfound_temp))
        {
            NodeUtils->message('E1', 'EMsgPREREQ_NOT_FOUND',
                               join(", ", @notfound_temp));
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX")
    {
    }
}

#--------------------------------------------------------------------------------

=head3 search_csm

        Search for rpms in the $::installms path and populate the
        $::Rpm_name_path and %::temp_CmdLinePathVersionName hash.

        If an rpm is not found, add it to the %::RpmsNotFoundInCmdPath hash.

        Arguments:
                none

        Returns:
                undefined

        Globals:
                $::Rpm_name_path
                %::RpmsNotFoundInCmdPath
                $::PREREQS_ATTR
                $::ATTRS
                @::csm_packages
                @::rsct_packages
                @::director_package
                @::PKGPATH
                $::INSTALLDIR_CSMPKG
                $::COPY_OPT_FLAG
        Error:
                undefined
        Example:
                ServerUtils->search_csm();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub search_csm
{
    if (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
        || ($::ATTRS{'InstallOSName'} eq "Linux"))
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',
                                  $::MSGMAPPATH,
                                  'csminstall',
                                  'I',
                                  'IMsgSearchingfor',
                                  "CSM, RSCT and  Director"
                                  );
        my @my_res_path = ();
        my ($rpmfile, $rpm, $path);

        # Determine the RPM architectures to search for on each platform.
        my @archs;
        my $arch = $::PREREQS_ATTR{'PkgArchitecture'};
        if (!$arch) { $arch = $::ATTRS{'InstallPkgArchitecture'}; }

        if ($arch =~ /i.86/)
        {
            @archs = ('i?86', 'noarch');
        }
        elsif ($arch =~ /ppc64/)
        {
            @archs = ($arch, 'ppc', 'noarch');
        }
        elsif ($arch =~ /x86_64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        elsif ($arch =~ /ia64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        else    # Any other unknown architectures.
        {
            @archs = ($arch, 'noarch');
        }

        # Search RPMs from CSM distribution CD-ROM or directory to dirctory structure
        foreach $rpm (@::csm_packages, @::rsct_packages, @::director_packages)
        {

            $rpmfile = '';
            $path    = '';
            foreach my $a (@archs)
            {
                if (!($path))
                {
                    $rpmfile = "${rpm}-*.$a.rpm";
                    $path = InstallUtils->findRpmInPath($rpmfile, @::PKGPATH);
                }
                else { last; }
            }
            if (!($path))
            {

                # we take out the dash because the images, may not have them.
                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $rpmfile = "${rpm}*.$a.rpm";
                        $path    =
                          InstallUtils->findRpmInPath($rpmfile, @::PKGPATH);
                    }
                    if ($path) { last; }
                }
            }

            if (defined($path))
            {
                $rpmfile = InstallUtils->getRecentVersionRpm($path, $rpmfile);

                chomp $rpmfile;
                my $rpmfile_basename;
                ($rpmfile_basename = $rpmfile) =~ s:^.*/::g;

                #find the shortname
                my @parts = split /-/, $rpmfile_basename;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }

                push @{$::temp_CmdLinePathVersionName{$path}},
                  $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'BaseName'}    = $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'Location'}    = $path;
                $::Rpm_name_path{$shortname}{'Destination'} =
                  $::INSTALLDIR_CSMPKG;
            }
            else
            {

                #get the shortname of the rpm
                my @parts = split /-/, $rpm;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }
                my $tmp_var1;
                my $my_rindex = rindex($shortname, "*");
                if ($my_rindex != -1)
                {
                    $tmp_var1 = substr($shortname, 0, rindex($shortname, "*"));
                }
                else { $tmp_var1 = $shortname; }
                $my_rindex = rindex($tmp_var1, "-");
                if (($my_rindex + 1) == 0) { $shortname = $tmp_var1; }
                elsif (($my_rindex + 1) == length($tmp_var1))
                {
                    $shortname = substr($tmp_var1, 0, rindex($tmp_var1, "*"));
                }
                else { $shortname = $tmp_var1; }
                push(@::RpmsNotFoundInCmdPath, $shortname);
            }

        }
        if ($::COPY_OPT_FLAG)
        {
            if (scalar(@::RpmsNotFoundInCmdPath) > 0)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', 'E1', 'EMsgNoRpmFound',
                                          join(", ", @::RpmsNotFoundInCmdPath));
            }
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX")
    {
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }
}

#--------------------------------------------------------------------------------

=head3 search_opensrc_prereqs

        Search for the open source rpms required for csm. If found then
        populate $::temp_CmdLinePathVersionName.

        Arguments:
                none

        Returns:
                undefined

        Globals:
                $::Rpm_name_path
                %::RpmsNotFoundInCmdPath
                $::temp_CmdLinePathVersionName.
                $::PREREQS_ATTR
                $::ATTRS
                @::PKGPATH
                $::INSTALLDIR_CSMPKG
                $::COPY_OPT_FLAG
        Error:
                message E1

        Example:
                ServerUtils->search_opensrc_prereqs();

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub search_opensrc_prereqs
{

    # Append /reqs and /reqs/<distro> to each PKGPATH element to search for pkgs
    my (@reqs_PKGPATH) = @::PKGPATH;    # Used for AIX
    map { s/$/\/reqs/ } @reqs_PKGPATH;  # Used for AIX
    my $distroname = (
                        $::PREREQS_ATTR{'DistributionName'}
                      ? $::PREREQS_ATTR{'DistributionName'}
                      : $::ATTRS{'InstallDistributionName'}
                      );
    my $distroversion = (
                           $::PREREQS_ATTR{'DistributionVersion'}
                         ? $::PREREQS_ATTR{'DistributionVersion'}
                         : $::ATTRS{'InstallDistributionVersion'}
                         );
    my $distro = $distroname . $distroversion;

    # Assemble the full_PKGPATH as follows:
    #  path1/reqs/distro:path1/reqs:path1:path2/reqs/distro/path2/reqs:path2
    my (@full_PKGPATH);
    foreach my $pkgpath (@::PKGPATH)
    {
        push(@full_PKGPATH, "$pkgpath/reqs/$distro");
        push(@full_PKGPATH, "$pkgpath/reqs");
        push(@full_PKGPATH, "$pkgpath");
    }

    if (   ($::PREREQS_ATTR{'OSName'} eq "Linux")
        || ($::ATTRS{'InstallOSName'} eq "Linux"))
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'I', 'IMsgSearchingfor', "Open Source");
        my ($rpm_pre_file, $rpm_pre, $path);

        # Determine the RPM architectures to search for on each platform.
        my @archs;
        my $arch = $::PREREQS_ATTR{'PkgArchitecture'};
        if (!$arch) { $arch = $::ATTRS{'InstallPkgArchitecture'}; }

        if ($arch =~ /i.86/)
        {
            @archs = ('i?86', 'noarch');
        }
        elsif ($arch =~ /ppc64/)
        {
            @archs = ($arch, 'ppc', 'noarch');
        }
        elsif ($arch =~ /x86_64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        elsif ($arch =~ /ia64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        else    # Any other unknown architectures.
        {
            @archs = ($arch, 'noarch');
        }

        # Search open source prereqs from CSM distribution CD-ROM or directory structure
        foreach $rpm_pre (@::opensrc_rpm_prereqs)
        {
            $rpm_pre_file = '';
            $path         = '';
	    
	    # ignore packages which has been installed 
	    #my $cmd = "$::RPMCMD -q $rpm_pre";
	    #NodeUtils->runcmd("$cmd",-1);
	    #next if($::RUNCMD_RC == 0);
	    

            # Process the IBMJava rpm begin.....
            if ($rpm_pre =~ /^IBMJava2-JRE/)
            {

                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $rpm_pre_file = "${rpm_pre}-*.$a.rpm";
                        $path         =
                          InstallUtils->findRpmInPath_java($rpm_pre_file,
                                                           @full_PKGPATH);
                    }
                    else { last; }
                }
                if (!($path))
                {
                    foreach my $a (@archs)
                    {
                        if (!($path))
                        {
                            $rpm_pre_file = "${rpm_pre}*.$a.rpm";
                            $path         =
                              InstallUtils->findRpmInPath_java($rpm_pre_file,
                                                               @full_PKGPATH);
                        }
                        if ($path) { last; }
                    }
                }

            }
            else    # Not IBMJava
            {

                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $rpm_pre_file = "${rpm_pre}-*.$a.rpm";
                        $path         =
                          InstallUtils->findRpmInPath($rpm_pre_file,
                                                      @full_PKGPATH);
                    }
                    else { last; }
                }
                if (!($path))
                {
                    foreach my $a (@archs)
                    {
                        if (!($path))
                        {
                            $rpm_pre_file = "${rpm_pre}*.$a.rpm";
                            $path         =
                              InstallUtils->findRpmInPath($rpm_pre_file,
                                                          @full_PKGPATH);
                        }
                        if ($path) { last; }
                    }
                }

            }
            if (defined($path))
            {

                # Get the latest version of the file in the first location found
                #my $rpm_pre_file = NodeUtils->runcmd("$::LS -vr $path/$rpm_pre_file | $::HEAD -1", -1);
                $rpm_pre_file =
                  InstallUtils->getRecentVersionRpm($path, $rpm_pre_file);

                chomp $rpm_pre_file;
                my $rpmfile_basename;
                ($rpmfile_basename = $rpm_pre_file) =~ s:^.*/::g;

                #find the shortname
                my @parts = split /-/, $rpmfile_basename;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }
                push @{$::temp_CmdLinePathVersionName{$path}},
                  $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'BaseName'}    = $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'Location'}    = $path;
                $::Rpm_name_path{$shortname}{'Destination'} =
                  $::INSTALLDIR_CSMPKG;
            }
            else
            {

                #get the shortname of the rpm
                my @parts = split /-/, $rpm_pre;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }
                my $tmp_var1;
                my $my_rindex = rindex($shortname, "*");
                if ($my_rindex != -1)
                {
                    $tmp_var1 = substr($shortname, 0, rindex($shortname, "*"));
                }
                else { $tmp_var1 = $shortname; }
                $my_rindex = rindex($tmp_var1, "-");
                if (($my_rindex + 1) == 0) { $shortname = $tmp_var1; }
                elsif (($my_rindex + 1) == length($tmp_var1))
                {
                    $shortname = substr($tmp_var1, 0, rindex($tmp_var1, "*"));
			    }
                else { $shortname = $tmp_var1; }

                if (! grep(/^$rpm_pre$/, @::mdgnode_open_srcrpms)) {
                    # ignore packages which has been installed
                    my $tmp_rpm_pre = $rpm_pre;
                    $tmp_rpm_pre =~s/\*//;
                    my $cmd = "$::RPMCMD -q $shortname|$::GREP $tmp_rpm_pre";

                    NodeUtils->runcmd("$cmd",-1);
                    if($::RUNCMD_RC == 0) {
                        push(@::RpmsNotBeCopied,$rpm_pre);
                        next;
                    }
                }

                push(@::RpmsNotFoundInCmdPath, $shortname);
            }
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX")
    {

        # Search open source prereqs from CSM distribution CD-ROM or directory structure
        foreach my $rpm_pre (@::opensrc_rpm_prereqs)
        {
	    # ignore packages which has been installed 
	    #my $cmd = "$::RPMCMD -q $rpm_pre";
	    #NodeUtils->runcmd("$cmd",-1);
	    #next if($::RUNCMD_RC == 0);

            # check for the ppc rpm in path and path/reqs....
            my $rpm_pre_file = "${rpm_pre}-*.ppc.rpm";
            my $path = InstallUtils->findRpmInPath($rpm_pre_file, @::PKGPATH);
            if (!($path))
            {
                $path =
                  InstallUtils->findRpmInPath($rpm_pre_file, @reqs_PKGPATH);
            }

            #...If ppc not found in path then check for the noarch rpm ....
            if (!($path))
            {
                $rpm_pre_file = "${rpm_pre}-*.noarch.rpm";
                $path = InstallUtils->findRpmInPath($rpm_pre_file, @::PKGPATH);
            }
            if (!($path))
            {
                $path =
                  InstallUtils->findRpmInPath($rpm_pre_file, @reqs_PKGPATH);
            }
            if (!($path))
            {
                $rpm_pre_file = "${rpm_pre}*.ppc.rpm";
                $path = InstallUtils->findRpmInPath($rpm_pre_file, @::PKGPATH);
                if (!($path))
                {
                    $path =
                      InstallUtils->findRpmInPath($rpm_pre_file, @reqs_PKGPATH);
                }

                #...If ppc not found in path then check for the noarch rpm ....
                if (!($path))
                {
                    $rpm_pre_file = "${rpm_pre}*.noarch.rpm";
                    $path         =
                      InstallUtils->findRpmInPath($rpm_pre_file, @::PKGPATH);
                }
                if (!($path))
                {
                    $path =
                      InstallUtils->findRpmInPath($rpm_pre_file, @reqs_PKGPATH);
                }
            }

            # And finally exit if the rpm is not found else copy
            if (defined($path))
            {

                # Get the latest version of the file in the first location found
                #my $rpmfile = NodeUtils->runcmd("$::LS $path/$rpm_pre_file | $::HEAD -1", -1);
                my $rpmfile =
                  InstallUtils->getRecentVersionRpm($path, $rpm_pre_file);

                chomp $rpmfile;
                my $rpmfile_basename;
                ($rpmfile_basename = $rpmfile) =~ s:^.*/::g;

                ArchiveUtils->copyRpm($rpmfile_basename, $path,
                                      $::INSTALLDIR_CSMRPM);
            }
            else
            {
                NodeUtils->message('E1', 'EMsgCANT_FIND', $rpm_pre,
                                   join(':', @::PKGPATH));
            }

        }
    }
    else
    {
        NodeUtils->message('E2', 'EMsgINVALID_OSTYPE');
    }
    if ($::COPY_OPT_FLAG)
    {
        if (scalar(@::RpmsNotFoundInCmdPath) > 0)
        {
            my @rpm_ignored     = ();
            my @rpm_not_ignored = ();
            foreach my $rpm_name (@::RpmsNotFoundInCmdPath)
            {
                if (   ($rpm_name =~ m/autoupdate/)
                    || ($rpm_name =~ m/perl-libnet/)
                    || ($rpm_name =~ m/perl-DBI/)
                    || ($rpm_name =~ m/perl-XML-Parser/)
                    || ($rpm_name =~ m/perl-XML-Simple/)
                    || ($rpm_name =~ m/fping/)
                    || ($rpm_name =~ m/perl-DB_File/))
                {
                    push(@rpm_ignored, $rpm_name);
                }
                else { push(@rpm_not_ignored, $rpm_name); }
            }
            @::RpmsNotFoundInCmdPath = @rpm_not_ignored;
            if (scalar(@rpm_ignored) > 0)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', 'I', 'IMsgMissingRPM',
                                          join(", ", @rpm_ignored));
            }
            if (scalar(@::RpmsNotFoundInCmdPath) > 0)
            {
                NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', 'E1', 'EMsgNoRpmFound',
                                          join(", ", @::RpmsNotFoundInCmdPath));
            }
        }
    }
}

#--------------------------------------------------------------------------------

=head3 search_rpm_csminstall_path

        Search the /csminstall.. path for the rpms not found in the
        installms path.   Valid ony if -c arg is not used while using
        installms and copycsmpkgs.

        Populate the $::temp_CmdLinePathVersionName and %::Rpm_name_path and if
        not found then populate the %::RpmsNotFoundInCmdPath

        Arguments:
                Array rpm Names
        Returns:
                none
        Globals:
                %::temp_CmdLinePathVersionName
                %::Rpm_name_path
                %::CmdLinePathVersionName
                @::Rpms_to_be_installed
                @::Rpms_already_installed
                @::Rpms_not_found
                @::RpmsNotFoundInCmdPath
                $::PREREQS_ATTR
                $::INSTALLDIR_CSMPKG
                $::INSTALLDIR_OS_NAME_RPMS

        Error:
                 NodeUtils->message 'E2'

        Example:
                 ServerUtils->search_rpm_csminstall_path(@::mgmtserver_open_srcrpms);

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub search_rpm_csminstall_path
{

    #Empty the the hashes already used
    %::temp_CmdLinePathVersionName = ();
    %::Rpm_name_path               = ();
    %::CmdLinePathVersionName      = ();
    @::Rpms_to_be_installed        = ();
    @::Rpms_already_installed      = ();
    @::Rpms_not_found              = ();
    @::RpmsNotFoundInCmdPath       = ();

    my ($class, @rpm_list) = @_;
    my (@my_path);
    if ($::PREREQS_ATTR{'OSName'} eq "Linux")
    {
        @my_path = ($::INSTALLDIR_CSMPKG, $::INSTALLDIR_OS_NAME_RPMS);
        my ($rpmfile, $rpm, $path);

        # Determine the RPM architectures to search for on each platform.
        my @archs;
        my $arch = $::PREREQS_ATTR{'PkgArchitecture'};
        if (!$arch) { $arch = $::ATTRS{'InstallPkgArchitecture'}; }

        if ($arch =~ /i.86/)
        {
            @archs = ('i?86', 'noarch');
        }
        elsif ($arch =~ /ppc64/)
        {
            @archs = ($arch, 'ppc', 'noarch');
        }
        elsif ($arch =~ /x86_64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        elsif ($arch =~ /ia64/)
        {
            @archs = ($arch, 'i?86', 'noarch');
        }
        else    # Any other unknown architectures.
        {
            @archs = ($arch, 'noarch');
        }

        # Search the RPMs from path
        foreach $rpm (@rpm_list)
        {
            $rpmfile = '';
            $path    = '';

            # Process the IBMJava rpm begin.....
            if ($rpm =~ /^IBMJava2-JRE/)
            {

                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $rpmfile = "${rpm}-*.$a.rpm";
                        $path    =
                          InstallUtils->findRpmInPath_java($rpmfile, @my_path);
                    }
                    else { last; }
                }
                if (!($path))
                {

                    # we take out the dash because the images, may not have them.
                    foreach my $a (@archs)
                    {
                        if (!($path))
                        {
                            $rpmfile = "${rpm}*.$a.rpm";
                            $path    =
                              InstallUtils->findRpmInPath_java($rpmfile,
                                                               @my_path);
                        }
                        if ($path) { last; }
                    }
                }

            }       #Process the IBMJava rpm end.....
            else    # Not IBMJava
            {

                foreach my $a (@archs)
                {
                    if (!($path))
                    {
                        $rpmfile = "${rpm}-*.$a.rpm";
                        $path = InstallUtils->findRpmInPath($rpmfile, @my_path);
                    }
                    else { last; }
                }
                if (!($path))
                {

                    # we take out the dash because the images, may not have them.
                    foreach my $a (@archs)
                    {
                        if (!($path))
                        {
                            $rpmfile = "${rpm}*.$a.rpm";
                            $path    =
                              InstallUtils->findRpmInPath($rpmfile, @my_path);
                        }
                        if ($path) { last; }
                    }
                }

            }
            if (defined($path))
            {
                $rpmfile = InstallUtils->getRecentVersionRpm($path, $rpmfile);

                chomp $rpmfile;
                my $rpmfile_basename;
                ($rpmfile_basename = $rpmfile) =~ s:^.*/::g;

                #find the shortname
                my @parts = split /-/, $rpmfile_basename;
                my $shortname = shift @parts;
                my $p;
              SNAME: while ($p = shift @parts)
                {
                    if ($p !~ m/^\d/)
                    {    #if it doesn't start with a digit
                        $shortname .= "-$p";
                    }
                    else { unshift @parts, $p; last SNAME; }
                }

                push @{$::temp_CmdLinePathVersionName{$path}},
                  $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'BaseName'} = $rpmfile_basename;
                $::Rpm_name_path{$shortname}{'Location'} = $path;
            }
            else { push(@::RpmsNotFoundInCmdPath, $rpm); }
        }
    }
    elsif ($::PREREQS_ATTR{'OSName'} eq "AIX")
    {
        NodeUtils->message("I", 'IMsgCOPYING_INSTALLP');

        # Copy RPMs from CSM distribution CD-ROM or directory to dirctory structure
        foreach my $image (@::csm_packages)
        {
            my $file = "${image}";
            my @images = InstallUtils->findImagesInPath($file, @::PKGPATH);
            foreach my $image (@images)
            {
                my $basename;
                ($basename = $image) =~ s:^.*/::g;
                my $path;
                ($path = $image) =~ s/$basename//g;
                ArchiveUtils->copyRpm($basename, $path,
                                      $::INSTALLDIR_CSMINSTLP);
            }
        }

        `inutoc $::INSTALLDIR_CSMINSTLP`;
    }
    else
    {
        NodeUtils->message('E2', 'EMsgINVALID_OSTYPE');
    }
}

#--------------------------------------------------------------------------------

=head3   show_copy_progress 

        Copy the entire contents of the Distro CD-ROMs

        Arguments:
                 $command
                 $destination
        Returns:
                none
        Globals:
               none
        Error:
                undefined

        Example:
               none

        Comments:  This function is intended to be used by copyDistroCD
                   subroutine.  This function shows the progress of CD copy
                   as %complete. It takes the 'tar' command which basically
                   copies the files from CD to disk and the destination dir
                   as the arguments. It pipes the output of the 'tar' command
                   and takes the size of each file as it gets copied. Calculates
                   the % value and displys it to the user as the files get copied.  


=cut

#--------------------------------------------------------------------------------

sub show_copy_progress
{
    my ($command, $target, $destination) = @_;
    my $totalSize  = 0;
    my $total      = 0;
    my $isLastFile = 0;
    my @output;
    my $mountPath   = $target;
    my $command_tmp = "du -s " . $mountPath;
    @output = NodeUtils->runcmd($command_tmp);
    my ($max) = split(/\s+/, $output[0]);
    $max =~ s/^\s*//;    # Remove any leading whitespace
    $max =~ s/\s*$//;    # Remove any trailing whitespace
    $totalSize = $max;
    if (!$totalSize) { $totalSize = 1; } # To avoid problem that user force use an empty CD.
    print("0% complete...\r");    #initial value

    my $firstFile = -1;
    my $file;
    my $lastFile;
    open(CMDOUT, "$command |")
      || NodeUtils->messageFromCat(
                                   'csmInstall.cat',            $::MSGMAPPATH,
                                   'csminstall',                'E',
                                   'EMsgERROR_RUNNING_COMMAND', $command
                                   );

    while (<CMDOUT>)
    {
        if ($firstFile == -1)
        {
            $firstFile = 1;
        }
        chomp;
        my $file1 = $_;
        $file1 =~ s/\.\/(.+)/\1/;    #example ./gcc-3.2.i386.rpm
        my $file = $destination . "/" . $file1;

        #whenever we get a new file, don't process it now. Save the file
        # and process the last file, hopefull by this time the last file is
        # fully copied to the disk.
        if ($file eq $lastFile)
        {
            next;
        }
        elsif ($firstFile)
        {
            $lastFile  = $file;
            $firstFile = 0;
            next;
        }
        else
        {
            $total =
              &displayProgress($lastFile, $total, $totalSize, $isLastFile);
            $lastFile = $file;
        }
    }    #end of whilea
    $isLastFile = 1;
    $total = &displayProgress($file, $total, $totalSize, $isLastFile);
    close(CMDOUT);
}

#--------------------------------------------------------------------------------

=head3    testVersion

        Compare version1 and version2 according to the operator and
        return True or False.

        Arguments:
                $version1
                $operator
                $version2
                $release1
                $release2
        Returns:
                True or False
        Globals:
                none
        Error:
                messageFromCat E11

        Example:
                if (ArchiveUtils->testVersion ( $ins_ver,
                                                "<",
                                                $req_ver,
                                                $ins_rel,
                                                $req_rel)){ blah; }

        Comments:
                The return value is generated with the Require query of the
                rpm command.

=cut

#--------------------------------------------------------------------------------

sub testVersion
{
    my ($class, $version1, $operator, $version2, $release1, $release2) = @_;

    # Note: perl seems to be able to handle really big integers, but if we run into a limit, we
    #       can use the Math::BigInt pkg

    my @a1 = split(/\./, $version1);
    my @a2 = split(/\./, $version2);
    my $len = (scalar(@a1) > scalar(@a2) ? scalar(@a1) : scalar(@a2));
    $#a1 = $len - 1;  # make the arrays the same length before appending release
    $#a2 = $len - 1;
    push @a1, split(/\./, $release1);
    push @a2, split(/\./, $release2);
    $len = (scalar(@a1) > scalar(@a2) ? scalar(@a1) : scalar(@a2));
    my $num1 = '';
    my $num2 = '';

    for (my $i = 0 ; $i < $len ; $i++)
    {
        my ($d1) = $a1[$i] =~ /^(\d*)/;    # remove any non-numbers on the end
        my ($d2) = $a2[$i] =~ /^(\d*)/;

        my $diff = length($d1) - length($d2);
        if ($diff > 0)                     # pad d2
        {
            $num1 .= $d1;
            $num2 .= ('0' x $diff) . $d2;
        }
        elsif ($diff < 0)                  # pad d1
        {
            $num1 .= ('0' x abs($diff)) . $d1;
            $num2 .= $d2;
        }
        else                               # they are the same length
        {
            $num1 .= $d1;
            $num2 .= $d2;
        }
    }

    # Remove the leading 0s or perl will interpret the numbers as octal
    $num1 =~ s/^0+//;
    $num2 =~ s/^0+//;

    #SuSE Changes
    # if $num1="", the "eval '$num1 $operator $num2'" will fail. So MUSTBE be sure that $num1 is not a "".
    if (length($num1) == 0) { $num1 = 0; }
    if (length($num2) == 0) { $num2 = 0; }

    #End of SuSE Changes

    if (length($release1))
    {
        $release1 = "-$release1";
    }    # this is just for error msgs
    if (length($release2))
    {
        $release2 = "-$release2";
    }    # this is just for error msgs

    if ($operator eq '=') { $operator = '=='; }
    my $bool = eval "$num1 $operator $num2";
    if (length($@))
    {
        NodeUtils->messageFromCat(
                              'csmInstall.cat',
                              $::MSGMAPPATH,
                              'csminstall',
                              'W',
                              'EMsgVERSION_COMPARE_PROBLEM',
                              "$version1$release1 $operator $version2$release2",
                              $@
                              );
        return undef;
    }
    if ($ENV{LANG} =~ /^(C|POSIX|en_US)/)
    {    #this is a work around for NLS problems
        NodeUtils->messageFromCat(
                              'csmInstall.cat',
                              $::MSGMAPPATH,
                              'csminstall',
                              'V',
                              'IMsgCOMPARING_VERSION',
                              "$version1$release1 $operator $version2$release2",
                              ($bool ? 'true' : 'false')
                              );
    }
    return $bool;
}

#--------------------------------------------------------------------------------

=head3	update_rpm_packages_to_csminstall

        Copy all appropriate rpms to csminstall.  Compare packages in PATH
	to /csminstall and only performa a copy if the files are more recent.
	Only prompt for CD's if file is not found in PATH or in /csminstall.

        Arguments:
		none
        Returns:
                none
        Globals:
        	$::COPY_OPT_FLAG
		@::Rpms_not_found
		@::RpmsNotFoundInCmdPath
        Error:
                messageFromCat E11

        Example:

        Comments:

		Dependancy on ServerUtils->create_directory_structure().
		Use if (!$::DONT_COPY_RPMS) is true.

=cut

#--------------------------------------------------------------------------------

sub update_rpm_packages_to_csminstall
{

    # get the version/release of the rpms in /csminstall directory
    ArchiveUtils->get_csminstall_pathVersion();

    # Copy csm packages to /csminstall
    ArchiveUtils->search_csm();

    # Copy open source packages to /csminstall
    ArchiveUtils->search_opensrc_prereqs();

    if ($::COPY_OPT_FLAG)
    {

        # force copy flag (-f) - copies all remaining CSM, RSCT,
        # Director and Open Source rpms to /csminstall

        if (scalar(@::RpmsNotFoundInCmdPath) >= 1)
        {
            NodeUtils->message('E1', 'EMsgNoRpmFound',
                               join(", ", @::RpmsNotFoundInCmdPath));
        }
        else
        {
            ArchiveUtils->create_rpm_list_to_copy();
            if (scalar(@::Rpms_not_found) >= 1)
            {
                NodeUtils->message('E1', 'EMsgNoRpmFound',
                                   join(", ", @::Rpms_not_found));
            }
            else
            {
                NodeUtils->message('I', 'IMsgCopyingRpms',
                                   "CSM, RSCT, Director and Open Source");

                ArchiveUtils->copy_rpm();
                ServerUtils->mk_link_for_addlcsext();
            }
        }
    }
    else    # ignores certain rpms during copy
    {
        ArchiveUtils->create_rpm_list_to_copy();
        if (scalar(@::Rpms_not_found) >= 1)
        {

            #check for the rpms to be ignored
            my @rpm_ignored     = ();
            my @rpm_not_ignored = ();
            foreach my $rpm_name (@::Rpms_not_found)
            {
                if (   ($rpm_name =~ m/autoupdate/)
                    || ($rpm_name =~ m/perl-libnet/)
                    || ($rpm_name =~ m/perl-DBI/)
                    || ($rpm_name =~ m/perl-XML-Parser/)
                    || ($rpm_name =~ m/perl-XML-Simple/)
                    || ($rpm_name =~ m/fping/))
                {
                    push(@rpm_ignored, $rpm_name);
                }
                else { push(@rpm_not_ignored, $rpm_name); }
            }
            @::Rpms_not_found = @rpm_not_ignored;
            if (scalar(@rpm_ignored) >= 1)
            {
                NodeUtils->message('I', 'IMsgMissingRPM',
                                   join(", ", @rpm_ignored));
            }
            if (scalar(@::Rpms_not_found) > 0)
            {
                NodeUtils->message('E1', 'EMsgNoRpmFound',
                                   join(", ", @::Rpms_not_found));
            }
            NodeUtils->message('I', 'IMsgCopyingRpms',
                               "CSM, RSCT, Director and Open Source");

            ArchiveUtils->copy_rpm();
            ServerUtils->mk_link_for_addlcsext();
        }
        else
        {
            NodeUtils->message('I', 'IMsgCopyingRpms',
                               "CSM, RSCT, Director and Open Source");
            ArchiveUtils->copy_rpm();
            ServerUtils->mk_link_for_addlcsext();
        }
    }

    # Search for the distro rpms
    ArchiveUtils->search_copy_distro_rpms();
}

#--------------------------------------------------------------------------------

=head3  unmount_iso_image

	Tries to unmount a file as an ISO image (a CD image as a file).

        Arguments:
                mount point (usually "/tmp_loop_mnt")
        Returns:
                $::OK if umount worked
		$::NOK if not
        Globals:
                none
        Error:
		none
        Example:
                 my $rc = ArchiveUtils->unmount_iso_image($mount_pt};
        Comments:
		none

=cut

#--------------------------------------------------------------------------------

sub unmount_iso_image
{
    my ($class, $mount_point) = @_;

    my $cmd = "$::UMOUNT $mount_point";

    NodeUtils->runcmd($cmd, -1);    # no exit on error
    my $rc = $::RUNCMD_RC;

    if ($rc == 0) { return $::OK; }

    return $::NOK;
}

#--------------------------------------------------------------------------------

=head2    installp Support

=cut

#--------------------------------------------------------------------------------

=head3    get_pkgVersion

        AIX only routine.

        Returns the installp image version from Installp command which,
        looks into the .toc file.

        Arguments:
                $installpPackage

        Returns:
                AIX installp image version as a string
        Globals:
                $::PLTFRM
                $::INSTALLPCMD

        Error:
                messageFromCat E2
        Example:
                not used outside ServerUtils

        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_pkgVersion
{
    my ($class, $pkg) = @_;
    my ($cmd, $output, $version);

    if ($::PLTFRM eq "Linux")
    {
        $version = "";
        return (length($version) ? $version : undef);
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $cmd    = qq($::INSTALLPCMD -L -d . | grep $pkg 2>&1);
        $output = NodeUtils->runcmd($cmd);
        chomp($output);
        (undef, undef, $version, undef) = split(/:/, $output);
        return (length($version) ? $version : undef);
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }

}

#--------------------------------------------------------------------------------

1;

